﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UploadFile : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string restr = "0";
        string classid = "";
        switch (Session["Type"].ToString())
        {
            case "1":
                classid = Session["ClassId"].ToString();
                break;
            case "2":
                classid = Session["ParClassId"].ToString();
                break;
            case "3":
                classid = Request.Cookies["HclassId"].Value;
                break;
            case "4":
                classid = Request.Cookies["TclassId"].Value;
                break;
        }
        HttpFileCollection file = Request.Files;
        for (int i = 0; i < file.Count; i++)
        {
            try
            {
                if (file[i].ContentLength < 10485760)
                {
                    //原图
                    string fileurl = DateTime.Now.ToString("yyyyMMddHHmmss") + ".jpg";
                    string bigurl = i + DateTime.Now.ToString("yyyyMMddHHmmss") + ".jpg";
                    string path = Server.MapPath("upfile") + "\\" + fileurl;
                    string Bpath = Server.MapPath("upfile") + "\\" + bigurl;
                    file[i].SaveAs(path);
                    FirstPic(path, Bpath);
                    //缩略图
                    string smailurl = "small\\" + i + DateTime.Now.ToString("yyyyMMddHHmmss") + ".jpg";
                    string Spath = Server.MapPath("upfile") + "\\" + smailurl;
                    SmallPic(path, Spath, 100, 75);

                    //*******创建班级图片信息*******//
                    WinStar.Model.ClassPhoto Cphoto = new WinStar.Model.ClassPhoto();
                    Cphoto.ClassId = int.Parse(classid.ToString());
                    Cphoto.CreateTime = DateTime.Now;
                    Cphoto.FileUrl = bigurl;
                    Cphoto.SmailUrl = smailurl;
                    Cphoto.Title = file[i].FileName;
                    switch (Session["Type"].ToString())
                    {
                        case "1":
                            Cphoto.UserType = 2;
                            Cphoto.UserId = int.Parse(Session["UserId"].ToString());
                            break;
                        case "2":
                            Cphoto.UserType = 3;
                            Cphoto.UserId = int.Parse(Session["ParId"].ToString());
                            break;
                        case "3":
                            Cphoto.UserType = 1;
                            Cphoto.UserId = int.Parse(Session["HteacherId"].ToString());
                            break;
                        case "4":
                            Cphoto.UserType = 1;
                            Cphoto.UserId = int.Parse(Session["TeacherId"].ToString());
                            break;
                    }
                    new WinStar.BLL.ClassPhoto().Add(Cphoto);
                    restr = "1";
                }
                else
                {
                    restr = "文件太大！";
                }
            }
            catch (Exception)
            {
            }

        }
        Response.Write(restr);
        Response.End();

    }

    /// <summary>
    /// 缩小图片
    /// </summary>
    /// <param name="strOldPic">源图文件名(包括路径)</param>
    /// <param name="strNewPic">缩小后保存为文件名(包括路径)</param>
    /// <param name="intWidth">缩小至宽度</param>
    /// <param name="intHeight">缩小至高度</param>
    public void SmallPic(string strOldPic, string strNewPic, int intWidth, int intHeight)
    {
        System.Drawing.Bitmap objPic, objNewPic;
        try
        {
            objPic = new System.Drawing.Bitmap(strOldPic);
            objNewPic = new System.Drawing.Bitmap(objPic, intWidth, intHeight);
            objNewPic.Save(strNewPic);
        }
        catch (Exception exp)
        { throw exp; }
        finally
        {
            objPic = null;
            objNewPic = null;
        }
    }

    /// <summary>
    /// 原始图片修改(过大裁剪)
    /// </summary>
    /// <param name="strOldPic">源图文件名(包括路径)</param>
    /// <param name="strNewPic">缩小后保存为文件名(包括路径)</param>
    /// <param name="intWidth">缩小至宽度</param>
    /// <param name="intHeight">缩小至高度</param>
    public void FirstPic(string strOldPic, string strNewPic)
    {
        System.Drawing.Bitmap objPic, objNewPic;
        try
        {
            objPic = new System.Drawing.Bitmap(strOldPic);
            objNewPic = new System.Drawing.Bitmap(objPic, 800, 600);
            int width = objPic.Width;
            int height = objPic.Height;
            width = width > 800 ? 800 : width;
            height = height > 600 ? 600 : height;
            objNewPic = new System.Drawing.Bitmap(objPic, width, height);
            objNewPic.Save(strNewPic);
        }
        catch (Exception exp)
        { throw exp; }
        finally
        {
            objPic = null;
            objNewPic = null;
        }
    }
}
