﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class _Default : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadSystem();
            this.LoadNewsType();
            this.LoadSchoolNotice();
        }

    }
    /// <summary>
    /// 加载新闻列表
    /// </summary>
    protected string LoadNewsList(string Id)
    {
        string retstr = "<li>暂无信息</li>";
        try
        {
            DataTable dt = new WinStar.BLL.News().GetList(5, "ClassId=" + Id + " And TypeLevel = 1","CreateTime Desc").Tables[0];
            if (dt.Rows.Count > 0)
            {
                retstr = "";
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    retstr += "<li><span>时间：<b>" + DateTime.Parse(dt.Rows[i]["CreateTime"].ToString()).ToString("yyyy年MM月dd日") + "</b> </span><span>&nbsp;查看：";
                    retstr += dt.Rows[i]["Hits"].ToString() == "" ? "0" : dt.Rows[i]["Hits"];
                    retstr += "<b> 次</b></span>";
                    retstr += "<a href=\"NewsView.aspx?Id=" + dt.Rows[i]["Id"] + "\" target=\"_blank\">" + dt.Rows[i]["Title"] + "</a><p>";
                    retstr += dt.Rows[i]["TitlePic"].ToString() != "" ? "<img src='" + Common.getUrl() + dt.Rows[i]["TitlePic"].ToString() + "'>" : "";
                    retstr += dt.Rows[i]["About"] + "</p>";
                    retstr += "</li>";
                }
            }
        }
        catch { }
        return retstr;
    }
    /// <summary>
    /// TOP 5 公告列表
    /// </summary>
    protected void LoadSchoolNotice()
    {
        this.NoticeList.DataSource = new WinStar.BLL.Notice().GetList(5, "ClassId=0", " CreateTime DESC");
        this.NoticeList.DataBind();
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
            this.NewsTypeList.DataSource = dt;
            this.NewsTypeList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}