﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class HomeMaster_CheckingList : ParentsPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.InitMenuMsg();
            this.InitDateStatus(); //初始化日期状态

            if (!string.IsNullOrEmpty(Request.QueryString["date"])) //用户有日期请求
            {
                if (!string.IsNullOrEmpty(Request.QueryString["isjs"]))
                {
                    Response.Write(this.LoadGroupNoteByDate(Request.QueryString["date"]));
                    Response.End();
                }
                else
                {
                    this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(Request.QueryString["date"].ToString());
                }
            }
            else //默认加载当前日期日子
            {
                this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(DateTime.Now.ToString("yyyy-MM-dd"));
            }
        }
    }
    /// <summary>
    /// 初始化日期状态
    /// </summary>
    protected void InitDateStatus()
    {
        this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']";
        try
        {
            string sql = string.Format("select distinct convert(varchar(25),CreateDate,23) as NoteDate from HS_Checking where UserId={0}", Session["ParId"]);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string dateList = ",disabledDates:[";
                foreach (DataRow dr in dt.Rows)
                {
                    dateList += "'" + dr[0] + "',";
                }
                dateList = dateList.TrimEnd(',');
                dateList += "]";

                this.ltMsg.Text += dateList;

                this.ltMsg.Text += "})</script>";
            }
            else
            {
                this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>";
            }
        }
        catch { this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; }
    }
    /// <summary>
    /// 根据日期加载学生考勤
    /// </summary>
    /// <param name="date">日期</param>
    protected string LoadGroupNoteByDate(string date)
    {
        System.Text.StringBuilder listStr = new System.Text.StringBuilder();
        try
        {
            string sqlWhere = string.Format(" UserId={0} and convert(varchar(25),CreateDate,23)='{1}'", Session["ParId"], date);
            DataTable dt = new WinStar.BLL.Checking().GetList(sqlWhere).Tables[0];

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        listStr.AppendLine("<table class=\"noteTable\">");
                        listStr.AppendLine("<tr style=\"background-color: #864B9E;Color:#fff; line-height: 30px;\"><th>");
                        listStr.AppendLine("<b>日期：</b>" + DateTime.Parse(dr["CreateDate"].ToString()).ToString("yyyy年MM月dd日"));
                        listStr.AppendLine("<b>状态：</b>" + this.LoadState(int.Parse(dr["State"].ToString())) + "</th></tr>");
                        listStr.AppendLine("<tr><td style=text-align:left;line-height:22px>");
                        listStr.AppendLine("<p class=\"noteContent\">到校时间：");
                        listStr.AppendLine(DateTime.Parse(dr["ToTime"].ToString()).ToString("tt hh 点 mm 分"));
                        listStr.AppendLine("</p><p class=\"noteContent\">离校时间：");
                        listStr.AppendLine(DateTime.Parse(dr["GoTime"].ToString()).ToString("tt hh 点 mm 分"));
                        listStr.AppendLine("</p>");
                        if (dr["About"].ToString().Length > 0)
                        {
                            listStr.AppendLine("</p><p class=\"noteContent\" style='color:red'>备注：");
                            listStr.AppendLine(dr["About"].ToString());
                            listStr.AppendLine("</p>");
                        }
                        listStr.AppendLine("</td></tr></table>");
                    }
                }
                else
                {
                    listStr.AppendLine("<center style=\"line-height:20px;color:red;\">" + DateTime.Parse(date).ToString("yyyy年MM月dd日") + "，没有考勤信息，点击左侧日历可查看历史考勤信息！</center>");
                }
            }
        }
        catch { listStr.Append("查询出错，请重试！"); }

        return listStr.ToString();
    }
    protected string LoadState(int id)
    {
        string str = string.Empty;
        try
        {
            switch (id)
            {
                case 1:
                    str = "<font color='green'>正常</font>";
                    break;
                case 2:
                    str = "<font color=#FF5555>迟到</font>";
                    break;
                case 3:
                    str = "<font color=#E036E0>早退</font>";
                    break;
                case 4:
                    str = "<font color=#0000FF>请假</font>";
                    break;
                case 5:
                    str = "<font color=#FF0000>迟到且早退</font>";
                    break;
                default:
                    str = "<font color=green>正常</font>";
                    break;
            }
        }
        catch { }

        return str;
    }

    private void InitMenuMsg()
    {
        try
        {
            this.ltMenuMsg.Text = new WinStar.BLL.Student().GetModel(Convert.ToInt32(Session["ParId"])).TrueName + "同学考勤情况";
        }
        catch { this.ltMenuMsg.Text = "考勤查看"; }
    }
}