﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

public partial class HomeMaster_GroupList : ParentsPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.InitTabMenu();

            this.LoadGroupList();
        }
    }
    /// <summary>
    /// 初始化Tab导航
    /// </summary>
    protected void InitTabMenu()
    {
        StringBuilder str = new StringBuilder();
        str.AppendLine("<ul class=\"SubjectTab\">");
        if (!string.IsNullOrEmpty(Request.QueryString["g"]))
        {
            if (Request.QueryString["g"].ToString() == "1")
            {
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=1\">已加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "1";
            }
            if (Request.QueryString["g"].ToString() == "0")
            {
                str.AppendLine("<li><a href=\"GroupList.aspx?g=1\">已加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "0";
            }
            if (Request.QueryString["g"].ToString() == "3")
            {
                str.AppendLine("<li><a href=\"GroupList.aspx?g=1\">已加入的小组</a></li>");
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "3";
            }
        }
        else
        {
            str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=1\">已加入的小组</a></li>");
            str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
            str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

            this.hidG.Value = "1";
        }
        str.AppendLine("</ul>");

        this.ltTabMenu.Text = str.ToString();
    }
    /// <summary>
    /// 加载兴趣小组列表
    /// </summary>
    protected void LoadGroupList()
    {
        try
        {
            string sql = string.Empty;
            if (!string.IsNullOrEmpty(Request.QueryString["g"]))
            {
                if (Request.QueryString["g"].ToString() == "1")
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=1", Session["ParId"]);
                }
                if (Request.QueryString["g"].ToString() == "3") //加载申请审核中的小组
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=0", Session["ParId"]);
                }
                if (Request.QueryString["g"].ToString() == "0") //加载其他兴趣小组
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.CreateTime,t.TrueName,g.TeacherId,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount from hs_group g,hs_teacher t where g.Id not in (select groupId from hs_groupUser where userId={0}) and t.Id=g.TeacherId order by MemberCount,g.CreateTime Desc", Session["ParId"]);
                }
            }
            else //默认则加载我加入的兴趣小组
            {
                sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=1", Session["ParId"]);
            }

            PagedDataSource pds = new PagedDataSource();
            System.Data.DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptGroupList.DataSource = pds;
            this.rptGroupList.DataBind();

        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupList();
    }
}