﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class HomeMaster_HomeworkList : ParentsPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["SId"]))
            {
                ViewState["SId"] = Request.QueryString["SId"];
            }
            else
            {
                ViewState["SId"] = "0";
            }
            this.InitMenuMsg();
            this.LoadSubjectList();
            this.LoadHomeWork();
        }

    }
    private void InitMenuMsg()
    {
        try
        {
            this.ltMenuMsg.Text = new WinStar.BLL.Student().GetModel(Convert.ToInt32(Session["ParId"])).TrueName + "同学作业情况";
        }
        catch { this.ltMenuMsg.Text = "作业查看"; }
    }
    /// <summary>
    /// 加载家庭作业
    /// </summary>
    protected void LoadHomeWork()
    {
        try
        {


            string sqlWhere = "";
            //判断条件
            if (ViewState["SId"].ToString() == "0")
            {
                sqlWhere = " ClassId=" + Session["ParClassId"].ToString();
            }
            else
            {
                sqlWhere = " ClassId=" + Session["ParClassId"].ToString() + " And SubjectId=" + ViewState["SId"];
            }
            sqlWhere += " Order By Id DESC";
            PagedDataSource pds = new PagedDataSource();
            System.Data.DataTable dt = new WinStar.BLL.HomeWork().GetList(sqlWhere).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.Repeater1.DataSource = pds;
            this.Repeater1.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 翻页事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        LoadHomeWork();
    }
    /// <summary>
    /// 加载操作
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    protected string LoadSumbitState(string Id)
    {
        string retunStr = "";
        try
        {
            System.Data.DataTable dt = new WinStar.BLL.SubmitWork().GetList("UserId=" + Session["ParId"].ToString() + " And HomeWorkId=" + Id).Tables[0];
            if (dt.Rows.Count > 0)
            {
                if (dt.Rows[0]["State"].ToString() == "2")
                {
                    retunStr = "<a href=\"SubmitWorkInfo.aspx?Id=" + Id + "&SumbitId=" + dt.Rows[0]["Id"] + "\" style='color:green'>查看作业</a>";
                }
                else
                {
                    retunStr = "<a href=\"SubmitWorkInfo.aspx?Id=" + Id + "&SumbitId=" + dt.Rows[0]["Id"] + "\">等待教师批改</a>";
                }
            }
            else
            {
                retunStr = "<font color=\"red\">未提交</font>";
            }
            return retunStr;
        }
        catch { return retunStr; }
    }
    /// <summary>
    /// 加载学生所拥有的科目
    /// </summary>
    protected void LoadSubjectList()
    {
        try
        {
            string gid = new WinStar.BLL.Class().GetModel(int.Parse(Session["ParClassId"].ToString())).GId.ToString(); //获取年级

            //加载年级课程关系表
            System.Data.DataTable dt = new WinStar.BLL.SubjectGrade().GetList("GId=" + gid).Tables[0];
            if (dt.Rows.Count > 0)
            {
                System.Text.StringBuilder listStr = new System.Text.StringBuilder();
                listStr.AppendLine("<ul class=\"SubjectTab\">");

                listStr.Append("<li class=\"");
                listStr.Append(("0" == (ViewState["SId"]).ToString()) ? "selected" : "");
                listStr.Append("\"><a href=\"HomeWorkList.aspx?SId=0\">所有学科</a></li>");

                foreach (string SId in dt.Rows[0]["SubjectId"].ToString().Split(','))
                {
                    listStr.Append("<li class=\"");
                    listStr.Append((SId == (ViewState["SId"]).ToString()) ? "selected" : "");
                    listStr.Append("\"><a href=\"HomeWorkList.aspx?SId=" + SId + "\">" + SubjectName(SId) + "</a></li>");
                }
                listStr.AppendLine("</ul>");
                this.tdSubjectList.InnerHtml = listStr.ToString();
            }
            else
            {
                this.tdSubjectList.InnerHtml = "<center>管理员还未设置你所在年级的科目，请过段时间查看！</center>";
            }
        }
        catch
        {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
    /// <summary>
    /// 通过科目ID返回科目名称
    /// </summary>
    /// <param name="id">科目ID</param>
    /// <returns></returns>
    protected string SubjectName(string id)
    {
        try
        {
            string Name = new WinStar.BLL.Subject().GetModel(int.Parse(id)).Name;
            if (Name != "")
            {
                return Name;
            }
            else
            {
                return "<font color=red>学科不存在</font>";
            }
        }
        catch
        {
            return "<font color=red>学科不存在</font>";
        }
    }
}