﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class HomeMaster_Login : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadSystem();
        }
    }
    protected void LoadSystem()
    {
        try
        {
            WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
            ViewState["SystemName"] = c.SystemName;
            ViewState["SchoolName"] = c.SName;
        }
        catch { }
    }
    /// <summary>
    /// 登录按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.Model.Student model = new WinStar.Model.Student();
            WinStar.BLL.Student bll = new WinStar.BLL.Student();

            string sqlWhere = string.Format(" Num = '{0}'", this.txtUserName.Text.Trim());

            List<WinStar.Model.Student> list = bll.GetModelList(sqlWhere);

            if (list.Count > 0)
            {
                model = list[0];
                if (this.txtUserPwd.Text.Trim() == model.ParentPWD)
                {
                    HttpCookie cookie = new HttpCookie("ParentsMaster");
                    cookie.Values["ParId"] = model.Id.ToString();
                    cookie.Values["ParNum"] = model.Num;
                    cookie.Values["ParClassId"] = model.ClassId.ToString();
                    Response.Cookies["Type"].Value = "2";

                    Response.Cookies.Add(cookie);

                    Session["ParId"] = model.Id.ToString(); //用户ID
                    Session["ParNum"] = model.Num; //学号
                    Session["ParClassId"] = model.ClassId.ToString();//班级ID
                    Session["Type"] = "2";
                    Response.Redirect("Default.aspx");
                }
                else //密码比对不正确
                {
                    Common.alert("用户名或密码错误！");
                }
            }
            else //未查询出用户信息
            {
                Common.alert("用户名或密码错误！");
            }
        }
        catch { Common.alert("登录失败，请重试！"); }
    }

}