﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class HomeMaster_SubmitWorkInfo : ParentsPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]) && !string.IsNullOrEmpty(Request.QueryString["SumbitId"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];  //作业ID
                ViewState["SumbitId"] = Request.QueryString["SumbitId"]; //作业提交表ID
                this.LoadHomeWork();
            }
            else
            {
                Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载家庭作业信息和提交的作业信息
    /// </summary>
    protected void LoadHomeWork()
    {
        try
        {
            //加载作业信息
            System.Text.StringBuilder listStr = new System.Text.StringBuilder();
            WinStar.Model.HomeWork h = new WinStar.BLL.HomeWork().GetModel(int.Parse(ViewState["Id"].ToString()));

            listStr.Append("<table width=98%  style=\"border:1px solid #864B9E;\"><tr><td style='line-height:30px;width:30%;padding-left:10px;' valign=top>");
            listStr.Append("<b>&nbsp;&nbsp;布&nbsp;置&nbsp;时&nbsp;间&nbsp;&nbsp;：</b>" + DateTime.Parse(h.CreateTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("<br/><b>要求完成时间：</b>" + DateTime.Parse(h.EndTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("</td><td style='text-align:left' valign=top>");
            listStr.Append("<b>作业题目内容：</b>" + h.Content);
            listStr.Append("</td></tr></table>");
            ViewState["SId"] = h.SubjectId;

            this.tdHomeWork.InnerHtml = listStr.ToString();

            //加载提交的作业信息
            System.Data.DataTable dt = new WinStar.BLL.SubmitWork().GetList("UserId=" + Session["ParId"].ToString() + " And Id=" + ViewState["SumbitId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.txtContent.InnerHtml = dt.Rows[0]["Content"].ToString();
                if (!string.IsNullOrEmpty(dt.Rows[0]["FileUrl"].ToString()))
                {
                    this.FileUrl.Visible = true;
                    this.FileUrl.InnerHtml = "<a href='" + Common.getUrl() + dt.Rows[0]["FileUrl"].ToString() + "' target='_blank'>下载附件</a>";
                }
            }
            else
            {
                Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
            }
        }
        catch
        {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
}