﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_CheckingAdd : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["date"]) && !string.IsNullOrEmpty(Request.QueryString["UserId"]))
            {
                ViewState["date"] = Request.QueryString["date"];
                ViewState["UserId"] = Request.QueryString["UserId"];
                LoadStudentInfo();
            }
        }
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    /// <param name="sid">学生Id</param>
    protected void LoadStudentInfo()
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(int.Parse(ViewState["UserId"].ToString()));
            this.ltStudentName.Text = "<font style=\"color:red;\">" + model.TrueName + "同学 " + DateTime.Parse(ViewState["date"].ToString()).ToString("yyyy年MM月dd日") + " </font> 考勤信息添加";
            ViewState["ClassId"] = model.ClassId;
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.Model.Checking c = new WinStar.Model.Checking();
            c.About = this.txtCommentContent.Text;
            c.CreateDate = DateTime.Parse(ViewState["date"].ToString());
            c.GoTime = this.txtGoTime.Text;
            c.State = int.Parse(this.txtState.SelectedValue);
            c.ToTime = this.txtToTime.Text;
            c.UserId = int.Parse(ViewState["UserId"].ToString());
            int num = new WinStar.BLL.Checking().Add(c);
            if (num > 0)
            {
                Response.Redirect("CheckingList.aspx?ClassId=" + ViewState["ClassId"].ToString() + "&date=" + ViewState["date"].ToString() + "");
            }
            else
            {
                Common.alert("添加失败！");
            }
        }
        catch
        {
            Common.alert("添加失败！");
        }
    }
}