﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_CheckingEdit : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];
                this.LoadChecking();
                LoadStudentInfo();
            }
        }
    }
    /// <summary>
    /// 加载考勤信息
    /// </summary>
    protected void LoadChecking()
    {
        try
        {
            WinStar.Model.Checking model = new WinStar.BLL.Checking().GetModel(int.Parse(ViewState["Id"].ToString()));
            this.txtCommentContent.Text = model.About;
            this.txtGoTime.Text = model.GoTime;
            this.txtState.SelectedValue = model.State.ToString();
            this.txtToTime.Text = model.ToTime;
            ViewState["date"] = model.CreateDate;
            ViewState["UserId"] = model.UserId;
        }
        catch { }
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    /// <param name="sid">学生Id</param>
    protected void LoadStudentInfo()
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(int.Parse(ViewState["UserId"].ToString()));
            this.ltStudentName.Text = "<font style=\"color:red;\">" + model.TrueName + "同学 " + DateTime.Parse(ViewState["date"].ToString()).ToString("yyyy年MM月dd日") + " </font> 考勤信息添加";
            ViewState["ClassId"] = model.ClassId;
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.Model.Checking c = new WinStar.Model.Checking();
            c.About = this.txtCommentContent.Text;
            c.CreateDate = DateTime.Parse(ViewState["date"].ToString());
            c.GoTime = this.txtGoTime.Text;
            c.State = int.Parse(this.txtState.SelectedValue);
            c.ToTime = this.txtToTime.Text;
            c.UserId = int.Parse(ViewState["UserId"].ToString());
            c.Id = int.Parse(ViewState["Id"].ToString());
            new WinStar.BLL.Checking().Update(c);
            Response.Redirect("CheckingList.aspx?ClassId=" + ViewState["ClassId"].ToString() + "&date=" + DateTime.Parse(ViewState["date"].ToString()).ToString("yyyy-MM-dd") + "");
        }
        catch
        {
            Common.alert("添加失败！");
        }
    }
}