﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Hteacher_ClassList : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
        {
            ViewState["Id"] = Request.QueryString["Id"];
            this.getMyClass();
        }
        if (!string.IsNullOrEmpty(Request.QueryString["State"]))
        {
            ViewState["State"] = Request.QueryString["State"];
        }
        else {
            ViewState["State"] = "0";
        }
        LoadMyClass();
    }
    /// <summary>
    /// 加载班级
    /// </summary>
    protected void getMyClass()
    {
        try
        {
            WinStar.BLL.TeacherClass t = new WinStar.BLL.TeacherClass();
            WinStar.Model.TeacherClass te = new WinStar.Model.TeacherClass();


            te.ClassId = int.Parse(ViewState["Id"].ToString());
            te.TeacherId = int.Parse(Request.Cookies["HteacherMaster"]["HteacherId"].ToString());

            //判断是否存在记录
            DataTable dt = t.GetList("ClassId=" + ViewState["Id"].ToString()).Tables[0];
            if (dt.Rows.Count > 0)
            {
                te.Id = int.Parse(dt.Rows[0]["Id"].ToString());
                t.Update(te);
            }
            else
            {
                t.Add(te);
            }
            Response.Write("1");
            Response.End();
        }
        catch { }
    }
    /// <summary>
    /// 加载我的班级。智能判断如果没有班级就认领班级
    /// </summary>
    protected void LoadMyClass()
    {
        if (ViewState["State"].ToString() == "0")
        {
            string sql = "Select * from HS_TeacherClass Where TeacherId=" + Request.Cookies["HteacherMaster"]["HteacherId"].ToString();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                //已经有班级就默认加载我的班级
                string cids = string.Empty;
                foreach (DataRow dr in dt.Rows)
                {
                    cids += dr[2] + ",";
                }
                LoadClass(cids.TrimEnd(','), true);

            }
            else
            {
                Response.Write("<script>alert('你暂时没有班级，建议认领班级');</script>");
                loadNotClass();
            }
        }
        else
        {
            loadNotClass();
        }
    }
    /// <summary>
    /// 如果班主任登录进来没有找到自己的班级，就让他认领班级
    /// </summary>
    protected void loadNotClass()
    {
        ViewState["State"] = "1";
        string sql = "Select * from HS_TeacherClass";
        DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
        string cids = string.Empty;
        if (dt.Rows.Count > 0)
        {
            foreach (DataRow dr in dt.Rows)
            {
                cids += dr[2] + ",";
            }
        }
        else {
            cids = "0";
        }
        
        LoadClass(cids.TrimEnd(','), false);
    }
    /// <summary>
    /// 加载班级信息
    /// </summary>
    /// <param name="cids">班级ID 多个 1,2,3</param>
    /// <param name="isnot">true false 是否已经有班级</param>
    protected void LoadClass(string cids,bool isnot)
    {
        string sql = string.Empty;
        if (isnot)
        {
            sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id in(" + cids + ") Order by c.ClassNum ASC";

        }
        else
        {
            sql = "Select g.TypeAge,g.YearIn,c.Id,c.ClassNum,c.GId From HS_Class c,HS_Grade g Where c.GId=g.Id And c.Id not in(" + cids + ") Order by c.gid,c.ClassNum ASC";
        }
        DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];


        this.Repeater1.DataSource = GetTable(dt);
        this.Repeater1.DataBind();
    }
    /// <summary>
    /// 对 DataTable 进行加工 过滤不要的东西
    /// </summary>
    /// <param name="table"></param>
    /// <returns></returns>
    public DataTable GetTable(DataTable table)
    {
        table.Columns.Add("ClassName");
        table.Columns.Add("StudentNum");
        foreach (DataRow row in table.Rows)
        {
            string CName = GetCname(int.Parse(row["Id"].ToString()));
            if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
            {
                row["ClassName"] = GetCname(int.Parse(row["Id"].ToString())) + "（" + row["ClassNum"] + "）班";
                row["StudentNum"] = GetStudentNum(row["Id"].ToString());
            }
            else {
                row.Delete();
            }
        }
        return table;

    }
    /// <summary>
    /// 班级人数
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    protected string GetStudentNum(string Id)
    {
        try
        {
            int num = new WinStar.BLL.Student().GetList("ClassId=" + Id).Tables[0].Rows.Count;
            return num.ToString() + "人";
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        try
        {
            string yein = "";
            int isgrade = 0;
            WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
            int gid = Convert.ToInt32(sclass.GId);
            WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
            yein = grade.YearIn.ToString();
            isgrade = Convert.ToInt32(grade.TypeAge);
            return GetGradeName(yein, isgrade);
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
}