﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Data.SqlClient;

public partial class Hteacher_CourseTableList : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["NId"]) && !string.IsNullOrEmpty(Request.QueryString["ClassId"]))
            {
                //
                if (!string.IsNullOrEmpty(Request.QueryString["isjs"]) && !string.IsNullOrEmpty(Request.QueryString["thisValue"]))
                {
                    if (Request.QueryString["isjs"] == "1")
                    {
                        this.LoadSubjectList(Request.QueryString["thisValue"], Request.QueryString["NId"], Request.QueryString["ClassId"]);
                    }
                    else
                    {
                        this.SetCourseTable(Request.QueryString["thisValue"], Request.QueryString["NId"], Request.QueryString["ClassId"]);
                    }
                }
                else//---请求的是取消修改课程
                {
                    this.LoadCourseName(Request.QueryString["NId"], Request.QueryString["ClassId"]);
                }
            }
            if (!string.IsNullOrEmpty(Request.QueryString["ClassId"]))
            {
                ViewState["ClassId"] = Request.QueryString["ClassId"];
            }
            else
            {
                ViewState["ClassId"] = "0";
            }
            this.LoadClass(); //先加载班级。后加载课程表
            this.LoadCourse();
        }
    }
    /// <summary>
    /// 加载课程名称
    /// </summary>
    /// <param name="nid">课程Id</param>
    /// <param name="classId">班级Id</param>
    private void LoadCourseName(object nid, object classId)
    {
        try
        {
            string sql = string.Format("select top 1 No"+nid+" from HS_CourseTable where ClassId={0}",classId);
            Response.Write(WinStar.DBUtility.DbHelperSQL.GetSingle(sql));
            Response.End();
        }
        catch {
            Response.Write("");
            Response.End();
        }
    }
    /// <summary>
    /// 修改课程表动作
    /// </summary>
    /// <param name="_thisValue">课程名称</param>
    /// <param name="_NId">字段序号</param>
    /// <param name="_ClassId">班级ID</param>
    protected void SetCourseTable(string _thisValue,string _NId,string _ClassId)
    {
        try
        {
            if (_thisValue == "0") {
                _thisValue = "";
            }
            StringBuilder strSql=new StringBuilder();
			strSql.Append("update HS_CourseTable set ");
			strSql.Append("No"+_NId+"=@NoName");
			strSql.Append(" where ClassId=@ClassId ");
			SqlParameter[] parameters = {
					new SqlParameter("@NoName", SqlDbType.VarChar,50),
					new SqlParameter("@ClassId", SqlDbType.Int,4)};
			parameters[0].Value = _thisValue;
			parameters[1].Value = _ClassId;
            int i = WinStar.DBUtility.DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
            if (i > 0)
            {
                Response.Write(_thisValue);
                Response.End();
            }
            else {
                Response.Write("0");
                Response.End();
            }
        }
        catch { }
        Response.Write("0");
        Response.End();
    }
    /// <summary>
    /// 加载所拥有的科目
    /// </summary>
    /// <param name="_thisValue">课程名称</param>
    /// <param name="_NId">班级字段</param>
    /// <param name="_ClassId">班级ID</param>
    protected void LoadSubjectList(string _thisvalue,string _NId,string _ClassId)
    {
        try
        {
            string gid = new WinStar.BLL.Class().GetModel(int.Parse(_ClassId)).GId.ToString(); //获取年级

            //加载年级课程关系表
            System.Data.DataTable dt = new WinStar.BLL.SubjectGrade().GetList("GId=" + gid).Tables[0];
            if (dt.Rows.Count > 0)
            {
                System.Text.StringBuilder listStr = new System.Text.StringBuilder();
                listStr.AppendLine("<select name=\"SubjectTab\"  onchange=\"changeMsg(this.value,'"+ _NId +"','"+ _ClassId +"')\">");
                listStr.AppendLine("<option value='0' style=\"color:red;\">选择课程</option>");
                foreach (string SId in dt.Rows[0]["SubjectId"].ToString().Split(','))
                {
                    string sname = SubjectName(SId);
                    if (_thisvalue == sname)
                    {
                        listStr.Append("<option value=\"" + sname + "\" selected=\"selected\">" + sname + "</option>");
                    }
                    else {
                        listStr.Append("<option value=\"" + sname + "\">" + sname + "</option>");
                    }
                }
                listStr.AppendLine("</select>");
                listStr.Append("<a href=\"javascript:cancelChange("+_NId+","+_ClassId+");\">取消</a>");
                Response.Write(listStr.ToString());
                Response.End();
            }
            else
            {
                Response.Write("<center>管理员还未设置你所在年级的科目，请过段时间查看！</center>");
                Response.End();
            }
        }
        catch
        {

        }
    }
    /// <summary>
    /// 通过科目ID返回科目名称
    /// </summary>
    /// <param name="id">科目ID</param>
    /// <returns></returns>
    protected string SubjectName(string id)
    {
        try
        {
            string Name = new WinStar.BLL.Subject().GetModel(int.Parse(id)).Name;
            if (Name != "")
            {
                return Name;
            }
            else
            {
                return "<font color=red>学科不存在</font>";
            }
        }
        catch
        {
            return "<font color=red>学科不存在</font>";
        }
    }
    /// <summary>
    /// 加载课程表
    /// </summary>
    protected void LoadCourse()
    {
        try
        {

            WinStar.BLL.CourseTable st = new WinStar.BLL.CourseTable();
            DataTable dt = st.GetList("ClassId=" + ViewState["ClassId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.Repeater1.DataSource = dt;
                this.Repeater1.DataBind();
            }
            else
            {
                WinStar.Model.CourseTable ct = new WinStar.Model.CourseTable();
                ct.ClassId = int.Parse(ViewState["ClassId"].ToString());
                st.Add(ct);
                LoadCourse();
            }
        }
        catch { }
    }

    /// <summary>
    /// 加载拥有的班级
    /// </summary>
    protected void LoadClass()
    {
        try
        {
            string str = "<ul class=\"SubjectTab\">";
            string sql = "Select * from HS_TeacherClass Where TeacherId=" + Request.Cookies["HteacherMaster"]["HteacherId"].ToString();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                if (ViewState["ClassId"].ToString() == "0")
                {
                    ViewState["ClassId"] = dt.Rows[0][2];
                }
                //已经有班级就默认加载我的班级
                foreach (DataRow dr in dt.Rows)
                {
                    string CName = GetCname(int.Parse(dr[2].ToString()));
                    if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
                    {
                        if (ViewState["ClassId"].ToString() == dr[2].ToString())
                        {
                            str += "<li class=\"selected\"><a href='CourseTableList.aspx?ClassId=" + dr[2].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[2].ToString())).ClassNum + ")班</a></li>";
                        }
                        else
                        {
                            str += "<li><a href='CourseTableList.aspx?ClassId=" + dr[2].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[2].ToString())).ClassNum + ")班</a></li>";
                        }
                    }
                }
                str += "</ul>";
                this.tdSubjectList.InnerHtml = str;
            }
            else
            {
                Common.alert("你暂时没有班级，建议认领班级！", "ClassList.aspx");
            }
        }
        catch { }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        try
        {
            string yein = "";
            int isgrade = 0;
            WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
            int gid = Convert.ToInt32(sclass.GId);
            WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
            yein = grade.YearIn.ToString();
            isgrade = Convert.ToInt32(grade.TypeAge);
            return GetGradeName(yein, isgrade);
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    
    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
}