﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_HnewAdd : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.classlist();
        }
    }
    /// <summary>
    /// 加载新闻列表
    /// </summary>
    protected void classlist()
    {
        try
        {
            string sql = "select  classid,HS_Class.*,HS_Grade.* ";
            sql += " from HS_TeacherClass,HS_Class,HS_Grade   ";
            sql += " where HS_TeacherClass.teacherid='" + Session["HTeacherId"].ToString() + "' and HS_Class.id=HS_TeacherClass.classid and HS_Grade.id=HS_Class.gid";
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string by = string.Empty;
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    by = GetGradeName(dt.Rows[i]["YearIn"].ToString(), int.Parse(dt.Rows[i]["TypeAge"].ToString()));

                    if (by.Trim() != "已经毕业")
                    {

                        this.CheckBoxList1.Items.Add(new ListItem(by + dt.Rows[i]["ClassNum"].ToString() + "班级", dt.Rows[i]["classid"].ToString()));
                    }
                }
            }
        }
        catch { }
    }   
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                string PicURL = string.Empty;
                if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
                {
                    string filename1 = FileUpload1.PostedFile.FileName;
                    string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                    if (ext != ".gif" && ext != ".jpg" && ext != ".jpeg" && ext != ".bmp" && ext != ".png")
                    {
                        Response.Write("<script>alert('图片文件格式不对!支持JPG、GIF、PNG、BMP格式。');history.back(-1);</script>");
                        return;
                    }
                    else
                    {
                        string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                        string path = Server.MapPath("/UploadFile/news/");
                        if (!Directory.Exists(path))
                        {
                            Directory.CreateDirectory(path);
                        }
                        string fpath = path + filename2 + ext;
                        FileUpload1.SaveAs(fpath);
                        PicURL = "/UploadFile/news/" + filename2 + ext;
                    }
                }

                if (this.nabout.Text.Length > 122)
                {
                    Common.alert("摘要字符不能超过122个！");
                    return;
                }
                string title = this.title.Text;

                string content = this.Summary.Value;
                WinStar.BLL.News n = new WinStar.BLL.News();
                WinStar.Model.News m = new WinStar.Model.News();
                m.Title = title;
                m.Content = content;
                m.TypeLevel = 2;
                m.Author = Session["HTeacherId"].ToString();
                m.About = this.nabout.Text;
                m.CreateTime = DateTime.Now;
                int y = 0;
                m.TitlePic = PicURL;
                for (int i = 0; i <= this.CheckBoxList1.Items.Count - 1; i++)
                {
                    if (this.CheckBoxList1.Items[i].Selected)
                    {
                        m.ClassId = int.Parse(this.CheckBoxList1.Items[i].Value);
                    }
                    if (m.ClassId != null)
                    {
                        n.Add(m);
                        y++;
                    }
                }
                if (y == 0)
                {
                    Common.alert("请选择班级！");
                }
                else
                {
                    Common.alert("添加成功！", "HNewslist.aspx");
                }
            }
            catch { Common.alert("添加失败，请重试！"); }
        }
    }   
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=red>请先设置好学期</font> <a href=TermList.aspx>点击这里</a>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "还没开学";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "已经毕业";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "已经毕业";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + isclass.ToString() + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";
        }
    }
    
    protected void btn1_Click(object sender, EventArgs e)
    {
        if (this.btn1.Text == "全选")
        {
            for (int b = 0; b < CheckBoxList1.Items.Count; b++)
            {

                this.CheckBoxList1.Items[b].Selected = true;
            }
            this.btn1.Text = "取消";
        }
        else
        {
            for (int b = 0; b < CheckBoxList1.Items.Count; b++)
            {

                this.CheckBoxList1.Items[b].Selected = false;
            }
            this.btn1.Text = "全选";
        }
    }
}