﻿using System;
using System.IO;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_HnewEdit : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                this.LoadNewsInfo();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！","Default.aspx",1);
            }
        }
    }

    private void LoadNewsInfo()
    {
        try
        {
            WinStar.BLL.News n = new WinStar.BLL.News();
            WinStar.Model.News mn = n.GetModel(int.Parse(Request["id"].ToString()));
            ViewState["Nid"] = Request["id"].ToString();
            this.title.Text = mn.Title;
            this.Summary.Value = mn.Content;
            this.nabout.Text = mn.About;
            if (mn.TitlePic != "")
            {
                this.piclink.Text = "<a href=\"" + mn.TitlePic + "\" target=\"_blank\">查看图片</a>";
            }
            this.banji.Text = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(mn.ClassId)));
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                string PicURL = string.Empty;
                if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
                {
                    string filename1 = FileUpload1.PostedFile.FileName;
                    string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                    if (ext != ".gif" && ext != ".jpg" && ext != ".jpeg" && ext != ".bmp" && ext != ".png")
                    {
                        Response.Write("<script>alert('图片文件格式不对!支持JPG、GIF、PNG、BMP格式。');history.back(-1);</script>");
                        return;
                    }
                    else
                    {
                        string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                        string path = Server.MapPath(@"..\UploadFile\news\");
                        if (!Directory.Exists(path))
                        {
                            Directory.CreateDirectory(path);
                        }
                        string fpath = path + filename2 + ext;
                        FileUpload1.SaveAs(fpath);
                        PicURL = "UploadFile/news/" + filename2 + ext;
                    }
                }

                if (this.nabout.Text.Length > 122)
                {
                    Common.alert("摘要字符不能超过122个！");
                    return;
                }
                WinStar.BLL.News n = new WinStar.BLL.News();
                WinStar.Model.News m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
                m.Title = this.title.Text;
                m.Content = this.Summary.Value;
                m.About = this.nabout.Text;
                m.CreateTime = DateTime.Now;
                if (PicURL != "")
                {
                    m.TitlePic = PicURL;
                }
                n.Update(m);
                Common.alert("修改成功！", "HNewslist.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}