﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_HnewsList : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["Type"] != null && Request["Type"].ToString() == "Del")
            {
                if (Request["id"] != null && Request["id"].ToString() != "")
                {
                    if (!this.NoticeDel(Request.QueryString["id"]))
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }
            }
            this.bindlist();
        }
    }
    protected void bindlist()
    {
        try
        {
            WinStar.BLL.News n = new WinStar.BLL.News();
            this.noticeList.DataSource = n.GetList("");
            PagedDataSource pds = new PagedDataSource();

            DataTable dt = n.GetList(" classid in (select classid from HS_TeacherClass where teacherid='" + Session["HteacherId"].ToString() + "') and TypeLevel=2 order by id desc").Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;

            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.noticeList.DataSource = pds;
            this.noticeList.DataBind();
        }
        catch { }
        
    }

    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        bindlist();
    }

    protected bool NoticeDel(string id)
    {
        bool result = false;
        try
        {
            WinStar.BLL.News u = new WinStar.BLL.News();
            u.Delete(int.Parse(id));

            result = true;
        }
        catch { }
        return result;
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnRpt_Click(object sender, EventArgs e)
    {
        int i = 0;
        try
        {
            foreach (RepeaterItem Item in this.noticeList.Items)
            {
                System.Web.UI.HtmlControls.HtmlInputCheckBox chk = (System.Web.UI.HtmlControls.HtmlInputCheckBox)Item.FindControl("ckbIndex");

                if (chk.Checked)
                {
                    new WinStar.BLL.News().Delete(int.Parse(chk.Value));
                    i++;
                }
            }
            if (i > 0)
            {
                Common.alert("删除成功！", "HNewsList.aspx");
                return;
            }
            else
            {
                Common.alert("没有选中的记录");
                return;
            }
        }
        catch
        {
            Common.alert("删除失败，请重试！");
        }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="cid">班级Id</param>
    /// <returns></returns>
    protected string getClassName(object cid)
    {
        string cName = "未知";
        try
        {
            cName = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(cid)));
        }
        catch { }
        return cName;
    }
}