﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_HnoticeEdit : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                this.LoadNoticeInfo();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！","Default.aspx",1);
            }
        }

    }
    /// <summary>
    /// 加载公告信息
    /// </summary>
    private void LoadNoticeInfo()
    {
        try
        {
            WinStar.BLL.Notice n = new WinStar.BLL.Notice();
            WinStar.Model.Notice mn = n.GetModel(int.Parse(Request["id"].ToString()));
            ViewState["Nid"] = Request["id"].ToString();
            this.title.Text = mn.Title;
            this.Summary.Value = mn.Content;
            this.banji.Text = Common.GetClassInfo(new WinStar.BLL.Class().GetModel(Convert.ToInt32(mn.ClassId)));
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.Notice n = new WinStar.BLL.Notice();
                WinStar.Model.Notice m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
                m.Title = this.title.Text;
                m.Content = this.Summary.Value;
                n.Update(m);

                Common.alert("修改成功！", "HNoticeList.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}