﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Data.SqlClient;

public partial class Hteacher_SelectStudentInfo : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["ClassId"]) && !string.IsNullOrEmpty(Request.QueryString["TypeId"]))
        {
            ViewState["ClassId"] = Request.QueryString["ClassId"];
            ViewState["TypeId"] = Request.QueryString["TypeId"];
            if (!string.IsNullOrEmpty(Request.QueryString["UserId"]))
            {
                this.ChangePower(Request.QueryString["UserId"]);
            }
            this.LoadSutdent();
        }
        else
        {
            Response.Write("<script>alert('加载失败，请重试！');var returnVal=\"0\";window.parent.hidePopWin(true)</script>");
        }
    }
    /// <summary>
    /// 修改权限
    /// </summary>
    /// <param name="UserId"></param>
    protected void ChangePower(string UserId)
    {
        try
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update HS_ClassPower set ");
            strSql.Append(ViewState["TypeId"].ToString() + "=@UserId");
            strSql.Append(" where ClassId=@ClassId ");
            SqlParameter[] parameters = {
				new SqlParameter("@UserId", SqlDbType.VarChar,50),
				new SqlParameter("@ClassId", SqlDbType.Int,4)};
            parameters[0].Value = UserId;
            parameters[1].Value = int.Parse(ViewState["ClassId"].ToString());
            int i = WinStar.DBUtility.DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
            if (i > 0)
            {
                Response.Write("<script>var returnVal = \"" + ViewState["TypeId"].ToString() + "," + LoadStudentName(UserId) + "\";window.parent.hidePopWin(true);</script>");
                Response.End();
            }
            else
            {
                Response.Write("<script>alert('加载失败，请重试！');var returnVal=\"0\";window.parent.hidePopWin(true)</script>");
                Response.End();
            }
        }
        catch { }
    }
    /// <summary>
    /// 学生姓名
    /// </summary>
    /// <param name="id">学生ID</param>
    /// <returns></returns>
    protected string LoadStudentName(string id)
    {
        try
        {
            string Name = new WinStar.BLL.Student().GetModel(int.Parse(id)).TrueName;
            if (Name != "")
            {
                return Name;
            }
            else
            {
                return "<font color=red>学生不存在</font>";
            }
        }
        catch
        {
            return "<font color=red>学生不存在</font>";
        }
    }
    /// <summary>
    /// 加载学生
    /// </summary>
    protected void LoadSutdent()
    {
        try
        {

            WinStar.BLL.Student st = new WinStar.BLL.Student();
            DataTable dt = st.GetList("ClassId=" + ViewState["ClassId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.Repeater1.DataSource = dt;
                this.Repeater1.DataBind();
            }
            else
            {
                this.LoadInfo.InnerHtml = "<center>暂时没有学生，建议<a href='UserAdd.aspx?ClassId=" + ViewState["ClassId"] + "'>添加</a>学生！</center>";
                this.LoadInfo.Visible = true;
            }
        }
        catch { }
    }
    /// <summary>
    /// 学生职务名称
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string StudentPost(string id)
    {
        try
        {
            return "<font color=red>" + new WinStar.BLL.StudentPost().GetModel(int.Parse(id)).Name + "</font>";
        }
        catch
        {
            return "无";
        }
    }
}