﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Drawing;
using System.Drawing.Imaging;
public partial class Hteacher_StuChart : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                this.loadsubject(Request["id"].ToString()); //加载考试学科

                ViewState["num"] = Request["id"].ToString();

                this.LoadResultImg(); //加载成绩图
            }
        }
    }
    /// <summary>
    /// 加载考试成绩图
    /// </summary>
    private void LoadResultImg()
    {
        try
        {
            string where = string.Empty;
            if (Request["sid"] != null && Request["sid"].ToString() != "")
            {
                where = " and e.sid='" + Request["sid"].ToString() + "'";
            }
            string sql = "select r.mark,e.ExamName,e.ExamTime,s.num,s.classid cid,s.Truename,r.id,e.id eid from HS_Results r,HS_ExamInfo e,HS_Student s where s.num=r.num and  r.eid=e.id " + where + " and r.num='" + Request["id"].ToString() + "' order by r.id asc";

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            dt.Columns.Add("NumList");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["NumList"] = i + 1;
            }
            if (dt.Rows.Count > 1)
            {
                Chart curve2d = new Chart();
                curve2d.Keys = new String[dt.Rows.Count];
                if (dt.Rows.Count > 12)
                {
                    curve2d.XSlice = 600 / dt.Rows.Count;
                }
                for (int i = 0; i < curve2d.Keys.Length; i++)
                {
                    curve2d.Keys[i] = dt.Rows[i][1].ToString();
                }
                curve2d.Values = new float[dt.Rows.Count];
                for (int i = 0; i < curve2d.Values.Length; i++)
                {
                    curve2d.Values[i] = float.Parse(dt.Rows[i][0].ToString());
                }
                Bitmap bmp = curve2d.CreateImage();
                try
                {
                    bmp.Save(Server.MapPath(@"Curve.jpg"), ImageFormat.Jpeg);                    // bmp.
                }
                catch { }
                finally
                {
                    bmp.Dispose();
                    this.dataList.DataSource = dt;
                    this.dataList.DataBind();
                    this.img.Visible = true;
                    this.img.Dispose();

                    this.img.Src = "Curve.jpg?" + DateTime.Now;
                }
            }
            else
            {
                if (dt.Rows.Count > 0)
                {
                    this.dataList.Visible = true;
                    this.img.Visible = false;
                    this.dataList.DataSource = dt;
                    this.dataList.DataBind();
                }
                else
                {
                    this.subList.Text = "<font color=\"red\">没有考试成绩</font><br /><input type=\"button\" class=\"btn\" value=\"返 回\" onclick=\"javascript:history.back(-1);\" />";
                    this.img.Visible = false;
                    this.dataList.Visible = false;
                }
            }
        }
        catch { }
    }
    /// <summary>
    /// 加载考试学科列表
    /// </summary>
    /// <param name="num"></param>
    protected void loadsubject(string num)
    {
        try
        {
            string str = "select s.name,s.id from HS_Results r,HS_ExamInfo e,HS_Subject s where Eid=e.id and e.Sid=s.id and r.num='" + num + "' group by s.id,s.name ";
            DataSet ds = WinStar.DBUtility.DbHelperSQL.Query(str);
            if (ds.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
                {
                    this.subList.Text += "<a href=\"?id=" + num + "&cid=" + i.ToString() + "&sid=" + ds.Tables[0].Rows[i]["id"].ToString() + "\" class=\"aCss\"><div id=\"divClass" + i.ToString() + "\">" + ds.Tables[0].Rows[i]["name"].ToString() + "</div></a>";

                }
                this.hidClassId.Value = Request.QueryString["cid"];
            }
        }
        catch { }
    }
}