﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Hteacher_StudentEdit : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                this.LoadStudentPost();
                ViewState["Id"] = Request.QueryString["Id"];
                this.LoadStudentInfo();
            }
            else { 
                Common.alert("加载错误，请重试!","StudentList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    protected void LoadStudentInfo()
    {
        try
        {
            WinStar.Model.Student a = new WinStar.BLL.Student().GetModel(int.Parse(ViewState["Id"].ToString()));
            this.txtNum.Text = a.Num;
            this.txtTrueName.Text = a.TrueName;
            this.txtSex.SelectedValue = a.Sex.ToString();
            this.txtPostId.SelectedValue = a.PostId.ToString();
            this.txtStudentPwd.Text = a.PassWord;
            this.txtParentPwd.Text = a.ParentPWD;
            ViewState["a"] = a;
        }
        catch
        {
            Common.alert("加载失败，请重试！", "StdentList.aspx");
        }
    }
    /// <summary>
    /// 加载学生职务
    /// </summary>
    protected void LoadStudentPost()
    {
        try {
            this.txtPostId.DataSource = new WinStar.BLL.StudentPost().GetAllList();
            this.txtPostId.DataTextField = "Name";
            this.txtPostId.DataValueField = "Id";
            this.txtPostId.DataBind();
            this.txtPostId.Items.Insert(0, new ListItem("没有职务", "0"));
        }
        catch { }
    }

    /// <summary>
    /// 添加 修改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        try
        {
            if (Page.IsValid)
            {
                WinStar.Model.Student a = new WinStar.Model.Student();
                a = (WinStar.Model.Student)ViewState["a"];
                a.Num = this.txtNum.Text;
                a.PostId = int.Parse(this.txtPostId.SelectedValue);
                a.TrueName = this.txtTrueName.Text;
                a.Sex = bool.Parse(this.txtSex.SelectedValue);
                a.ParentPWD = this.txtParentPwd.Text;
                a.PassWord = this.txtStudentPwd.Text;
                new WinStar.BLL.Student().Update(a);
                Response.Redirect("StudentList.aspx?ClassId=" + a.ClassId);
            }
        }
        catch
        {
            Common.alert("操作失败，请重试！", "StudentList.aspx");
        }
    }
    /// <summary>
    /// 检测用户名验证事件
    /// </summary>
    /// <param name="source"></param>
    /// <param name="args"></param>
    protected void cvNum_ServerValidate(object source, ServerValidateEventArgs args)
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(int.Parse(ViewState["Id"].ToString()));
            if (model.Num == this.txtNum.Text)
            {
                args.IsValid = true;
            }
            else
            {
                string sql = string.Format("select 1 from HS_Student where Num='{0}'",this.txtNum.Text);
                if (WinStar.DBUtility.DbHelperSQL.Exists(sql))
                    args.IsValid = false;
                else
                    args.IsValid = true;
            }
        }
        catch { }
    }
}