﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Hteacher_StudentInfo : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["CId"]))
            {
                ViewState["CId"] = Request.QueryString["CId"];
                this.DeleteComment();
            }
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id != 0)
                {
                    this.LoadStudentInfo(id);
                }
                else
                {
                    Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');window.parent.hidePopWin();</script>");
                }
            }
            else
            {
                Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');window.parent.hidePopWin();</script>");
            }
        }
    }
    /// <summary>
    /// 删除学生
    /// </summary>
    protected void DeleteComment()
    {
        try
        {
            new WinStar.BLL.Comment().Delete(int.Parse(ViewState["CId"].ToString()));
        }
        catch { }
    }
    /// <summary>
    /// 加载学生信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadStudentInfo(int id)
    {
        try
        {
            WinStar.Model.Student model = new WinStar.BLL.Student().GetModel(id);
            object ClassNum = new WinStar.BLL.Class().GetModel(Convert.ToInt32(model.ClassId)).ClassNum;
            this.ltClassName.Text = this.GetCname(Convert.ToInt32(model.ClassId)) + "(&nbsp;" + ClassNum + "&nbsp;)班";

            this.LoadComment(id);

            if (model.PostId.ToString() == "0")
            {
                this.ltPost.Text = "无职务";
            }
            else
            {
                this.ltPost.Text = new WinStar.BLL.StudentPost().GetModel(Convert.ToInt32(model.PostId)).Name;
            }
            this.ltSex.Text = model.Sex == true ? "男" : "女";
            this.ltStudyNum.Text = model.Num;
            this.ltTrueName.Text = model.TrueName;
            this.ltTitle.Text = this.GetCname(Convert.ToInt32(model.ClassId)) + "(&nbsp;" + ClassNum + "&nbsp;)班&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + model.TrueName + "同学个人信息";
        }
        catch { }
    }
    /// <summary>
    /// 加载评语信息
    /// </summary>
    /// <param name="UserId"></param>
    protected void LoadComment(object UserId)
    {
        try
        {
            string sql = string.Format("select  CreateTime,Content,TeacherId,TypeId,Id from hs_comment where [UserId]={0} order by Id Desc", UserId);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    this.ltCommentMsg.Text += "(<b>评语时间：</b>" + DateTime.Parse(dt.Rows[i]["CreateTime"].ToString()).ToString("yyyy年MM月dd日") + "&nbsp;&nbsp;<b>评语老师：</b>" + new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(dt.Rows[i]["TeacherId"])).TrueName + ")";
                    this.ltCommentMsg.Text += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"StudentInfo.aspx?CId=" + dt.Rows[i]["Id"].ToString() + "&id=" + UserId + "\" onclick=\"return confirm('确认删除此条评语吗?')\"><font color=red>删除</font></a>";
                    this.ltCommentMsg.Text += "<br/><br/>" + GetTypeId(dt.Rows[i]["TypeId"].ToString()) + dt.Rows[i]["Content"].ToString() + "<hr/>";
                }
            }
            else
            {
                this.ltComment.Text = "<font color=\"red\">最近没有老师给予评语！</font>";
            }
        }
        catch { this.ltComment.Text = "<font color=\"red\">暂无！</font>"; }
    }
    /// <summary>
    /// 评语类型
    /// </summary>
    /// <param name="id">类型</param>
    /// <returns></returns>
    protected string GetTypeId(string id)
    {
        string restr = "<font color='#50CF25'>【每日评语】</font>";
        switch (int.Parse(id))
        {
            case 1:
                restr = "<font color='#ff0000'>【学期评语】</font>";
                break;
            case 2:
                restr = "<font color='#CF7A25'>【每月评语】</font>";
                break;
            case 3:
                restr = "<font color='#CF25CF'>【每周评语】</font>";
                break;
            case 4:
                restr = "<font color='#50CF25'>【每日评语】</font>";
                break;
            default:
                restr = "<font color='#50CF25'>【每日评语】</font>";
                break;
        }
        return restr;

    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade);
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }

    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
}