﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Hteacher_StudentList : HteacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {

            if (!string.IsNullOrEmpty(Request.QueryString["SId"]))
            {
                ViewState["SId"] = Request.QueryString["SId"];
                this.StudentDelete();
            }
            if (!string.IsNullOrEmpty(Request.QueryString["ClassId"]))
            {
                ViewState["ClassId"] = Request.QueryString["ClassId"];
            }
            else {
                ViewState["ClassId"] = "0";
            }
            this.LoadClass(); //先加载班级。后加载学生
            this.LoadSutdent();
        }
    }
    /// <summary>
    /// 删除学生
    /// </summary>
    protected void StudentDelete()
    {
        try {
            new WinStar.BLL.Student().Delete(int.Parse(ViewState["SId"].ToString()));
        }
        catch { }
    }
    /// <summary>
    /// 加载学生
    /// </summary>
    protected void LoadSutdent()
    {
        try {

            WinStar.BLL.Student st = new WinStar.BLL.Student();
            DataTable dt = st.GetList("ClassId=" + ViewState["ClassId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.Repeater1.DataSource = dt;
                this.Repeater1.DataBind();
            }
            else {
                this.LoadInfo.InnerHtml = "<center>暂时没有学生，建议<a href='StudentAdd.aspx?ClassId="+ ViewState["ClassId"] +"'>添加</a>学生！</center>";
                this.LoadInfo.Visible = true;
            }
        }
        catch { }
    }
    /// <summary>
    /// 学生职务名称
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string StudentPost(string id)
    {
        try {
            return "<font color=red>" + new WinStar.BLL.StudentPost().GetModel(int.Parse(id)).Name + "</font>";
        }
        catch {
            return "无";
        }
    }
    /// <summary>
    /// 加载拥有的班级
    /// </summary>
    protected void LoadClass()
    {
        try
        {
            string str ="<ul class=\"SubjectTab\">";
            string sql = "Select * from HS_TeacherClass Where TeacherId=" + Request.Cookies["HteacherMaster"]["HteacherId"].ToString();
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                if (ViewState["ClassId"].ToString() == "0")
                {
                    ViewState["ClassId"] = dt.Rows[0][2];
                }
                //已经有班级就默认加载我的班级
                foreach (DataRow dr in dt.Rows)
                {
                    string CName = GetCname(int.Parse(dr[2].ToString()));
                    if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
                    {
                        if (ViewState["ClassId"].ToString() == dr[2].ToString())
                        {
                            str += "<li class=\"selected\"><a href='StudentList.aspx?ClassId=" + dr[2].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[2].ToString())).ClassNum + ")班</a></li>";
                        }
                        else {
                            str += "<li><a href='StudentList.aspx?ClassId=" + dr[2].ToString() + "'>" + CName + "(" + new WinStar.BLL.Class().GetModel(int.Parse(dr[2].ToString())).ClassNum + ")班</a></li>";
                        }
                    }
                }
                str += "</ul>";
                this.tdSubjectList.InnerHtml = str;
            }
            else
            {
                Common.alert("你暂时没有班级，建议认领班级！", "ClassList.aspx");
            }
        }
        catch { }
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        try
        {
            string yein = "";
            int isgrade = 0;
            WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
            int gid = Convert.ToInt32(sclass.GId);
            WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
            yein = grade.YearIn.ToString();
            isgrade = Convert.ToInt32(grade.TypeAge);
            return GetGradeName(yein, isgrade);
        }
        catch { return ""; }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Redirect("StudentAdd.aspx?ClassId=" + ViewState["ClassId"]);
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        Response.Redirect("StudentAdds.aspx?ClassId=" + ViewState["ClassId"]);
    }
}