﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Hteacher_TeacherSubject : HteacherPageBase
{
    public string SubjectStr = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request["Id"] != "" && Request["Id"] != null)
        {
            ViewState["Id"] = Request["Id"];
            if (Request["ClassId"] != "" && Request["ClassId"] != null)
            {
                ViewState["ClassId"] = Request["ClassId"];
                LoadGradeSubject();
            }
        }
        else
        {
            Common.alert("请用正确的浏览方式查看！", "GradeList.aspx");
        }
    }
    /// <summary>
    /// 加载该年级所含有的科目
    /// </summary>
    protected void LoadGradeSubject()
    {
        try
        {
            WinStar.BLL.SubjectGrade s = new WinStar.BLL.SubjectGrade();
            DataTable dt = s.GetList("GId=" + ViewState["Id"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string[] ad = dt.Rows[0]["SubjectId"].ToString().Split(',');
                if (ad.Length > 0)
                {
                    for (int i = 0; i < ad.Length; i++)
                    {
                        SubjectStr += "<font color=red style=font-weight:bold>" + new WinStar.BLL.Subject().GetModel(int.Parse(ad[i])).Name + "：</font>";
                        LoadSubject(ad[i]);
                        SubjectStr += "<br/>";
                    }
                }
            }
        }
        catch { }
    }
    /// <summary>
    /// 加载老师
    /// </summary>
    /// <param name="SubjectId">学科ID</param>
    protected void LoadSubject(string SubjectIdt)
    {
        WinStar.BLL.Teacher s = new WinStar.BLL.Teacher();
        DataTable dt = s.GetAllList().Tables[0];
        if (dt.Rows.Count > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                SubjectStr += "&nbsp;<input id=\"CheckBox_" + dt.Rows[i]["Id"] + "_" + ViewState["ClassId"] + "_" + SubjectIdt + "\" " + LoadSubjectChecked(dt.Rows[i]["Id"].ToString(), ViewState["ClassId"].ToString(), SubjectIdt) + " value=\"" + dt.Rows[i]["Id"] + "|" + SubjectIdt + "\" onclick=\"AddSubject('" + dt.Rows[i]["Id"] + "_" + ViewState["ClassId"] + "_" + SubjectIdt + "')\" type=\"radio\" name=\"radio1" + SubjectIdt + "\"/>&nbsp;" + dt.Rows[i]["TrueName"] + "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
        }
        else
        {
            Common.alert("请要求管理员先录入老师！", "ClassList.aspx");
        }
    }
    /// <summary>
    /// 加载是否选中的该老师
    /// </summary>
    /// <param name="TeacherId">老师ID</param>
    /// <param name="ClassId">班级ID</param>
    /// <param name="SubjectId">学科ID</param>
    /// <returns></returns>
    protected string LoadSubjectChecked(string TeacherId, string ClassId, string SubjectId)
    {
        try
        {
            string returnStr = "";
            DataTable dt = new WinStar.BLL.TeacherSubject().GetList("ClassId=" + ClassId + " And TeacherId=" + TeacherId + " And SubjectId=" + SubjectId).Tables[0];
            if (dt.Rows.Count > 0)
            {
                returnStr = "Checked=\"Checked\"";
            }
            return returnStr;
        }
        catch {
            return "";
        }
    }
    protected void btn1_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.BLL.TeacherSubject t = new WinStar.BLL.TeacherSubject();
            WinStar.Model.TeacherSubject te = new WinStar.Model.TeacherSubject();


            te.ClassId = int.Parse(ViewState["ClassId"].ToString());

            //this.getTeacherId.Value 值的储存方式 老师ID|学科ID，老师ID|学科ID
            //循环储存科任老师和班级学科的关系
            string[] TSIds = this.getTeacherId.Value.TrimEnd(',').Split(',');
            if (TSIds.Length > 0)
            {
                for (int i = 0; i < TSIds.Length; i++)
                {
                    string[] TSId = TSIds[i].Split('|');
                    te.TeacherId = int.Parse(TSId[0]);
                    te.SubjectId = int.Parse(TSId[1]);

                    //判断是否存在记录
                    DataTable dt = t.GetList("ClassId=" + ViewState["ClassId"] + " And SubjectId=" + TSId[1]).Tables[0];
                    if (dt.Rows.Count > 0)
                    {
                        te.Id = int.Parse(dt.Rows[0]["Id"].ToString());
                        t.Update(te);
                    }
                    else
                    {
                        t.Add(te);
                    }

                }
            }

            Common.alert("科任老师设置成功！", "ClassList.aspx");
        }
        catch { }
    }
}