﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class NewsList : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];
            }
            else
            {
                Common.alert("地址不存在,请用正确的浏览方式！", "Default.aspx");
            }
            this.LoadSystem();
            this.LoadNewsType();
            this.LoadSchoolNews();
        }
    }
    /// <summary>
    /// 新闻列表
    /// </summary>
    protected void LoadSchoolNews()
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = new WinStar.BLL.News().GetList("ClassId=" + ViewState["Id"] + " And TypeLevel = 1 Order By CreateTime DESC").Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.Notice_List.DataSource = pds;
            this.Notice_List.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadSchoolNews();
    }
    protected string getTypeName(string id)
    {
        string str = "获取失败";
        try {
            str = new WinStar.BLL.NewsType().GetModel(int.Parse(id)).Name;
        }
        catch { }
        return str;
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}