﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class NewsView : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];
            }
            else
            {
                Common.alert("地址不存在,请用正确的浏览方式！", "Default.aspx");
            }
            this.LoadSystem();
            this.LoadSchoolNews();//先加载新闻获得新闻ID 再加载新闻分类，高亮显示
            this.LoadNewsType();
        }
    }
    /// <summary>
    /// 新闻显示
    /// </summary>
    protected void LoadSchoolNews()
    {
        try
        {
            WinStar.Model.News n = new WinStar.BLL.News().GetModel(int.Parse(ViewState["Id"].ToString()));
            this.txtTitle.Text = n.Title;
            this.txtCreateTime.Text = "通知时间：<b>" + DateTime.Parse(n.CreateTime.ToString()).ToString("yyyy年MM月dd日") + "</b>";
            this.txtDept.Text = "作者：<b>" + n.Author + "</b>";
            this.txtAbout.Text = "新闻导读：" + n.About;
            this.txtContent.Text = n.Content;
            ViewState["TypeId"] = n.ClassId;

            string _Hit = "";
            _Hit += "点击次数：<b>";
            _Hit += string.IsNullOrEmpty(n.Hits.ToString()) ? "0" : n.Hits.ToString();
            _Hit += " 次</b>";
            this.txtHits.Text = _Hit;

            string sqlHits = string.IsNullOrEmpty(n.Hits.ToString()) ? "0" : n.Hits.ToString();
            WinStar.DBUtility.DbHelperSQL.ExecuteSql("Update HS_News Set Hits=" + sqlHits + "+1 Where Id=" + ViewState["Id"]);

        }
        catch { }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}