﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class StarTeacherView : IndexPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];
            }
            else
            {
                Common.alert("地址不存在,请用正确的浏览方式！", "Default.aspx");
            }
            this.LoadSystem();
            this.LoadNewsType();
            this.LoadStarTeacher();
        }
    }
    /// <summary>
    /// 名师显示
    /// </summary>
    protected void LoadStarTeacher()
    {
        try
        {
            WinStar.Model.StarTeacher n = new WinStar.BLL.StarTeacher().GetModel(int.Parse(ViewState["Id"].ToString()));
            this._txtTrueName.Text = n.TrueName;
            this.txtSubject.Text = "所任科目：<b>" + n.Subjects + "</b>";
            this.txtAptitude.Text = "教师资质：<b>" + n.Aptitude + "</b>";
            string _sex = (true).Equals(n.Sex) ? "男" : "女";
            this.txtSex.Text = "性别：<b>" + _sex + "</b>";
            this.txtTrueName.Text = "真实姓名：<b>" + n.TrueName + "</b>";
            string PicU = string.IsNullOrEmpty(n.PicUrl.ToString()) ? "ClassShow/Images/reg_icon.png" : n.PicUrl.ToString();
            this.txtAbout.Text = "<img src=\"" + PicU + "\" onerror=\"this.src='ClassShow/Images/reg_icon.png'\" style='float:left;padding-right:10px;'/>" + n.About;

        }
        catch { }
    }
    /// <summary>
    /// 加载新闻分类
    /// </summary>
    protected void LoadNewsType()
    {
        try
        {
            DataTable dt = new WinStar.BLL.NewsType().GetAllList().Tables[0];
            this.NewsType.DataSource = dt;
            this.NewsType.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载配置信息
    /// </summary>
    protected void LoadSystem()
    {
        WinStar.Model.Config c = new WinStar.BLL.Config().GetModel(1);
        ViewState["SystemName"] = c.SystemName;
        ViewState["SchoolName"] = c.SName;
    }
}