﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_AskAdd : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
            {
                ViewState["Id"] = Request.QueryString["Id"];
                this.LoadAsk();
            }
            else {
                ViewState["Id"] = "0";
            }
            this.LoadSubjectList();
        }
    }
    /// <summary>
    /// 加载ASK
    /// </summary>
    protected void LoadAsk()
    {
        try {
            WinStar.Model.Ask a = new WinStar.BLL.Ask().GetModel(int.Parse(ViewState["Id"].ToString()));
            if (a.UserId == int.Parse(Request.Cookies["StudentMaster"]["UserId"].ToString()))
            {
                this.txtContent.Value = a.Content;
                this.txtSubject.SelectedValue = a.SubjectId.ToString();
                this.txtTitle.Text = a.Title;
                ViewState["a"] = a;
            }
            else {
                Common.alert("加载失败，请重试！", "AskList.aspx?State=0");
            }
        }
        catch {
            Common.alert("加载失败，请重试！", "AskList.aspx?State=0");
        }
    }

    /// <summary>
    /// 添加 修改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        try
        {
            WinStar.Model.Ask a = new WinStar.Model.Ask();
            WinStar.BLL.Ask bll = new WinStar.BLL.Ask();

            if (ViewState["Id"].ToString() == "0")
            {
                a.ClassId = int.Parse(Request.Cookies["StudentMaster"]["ClassId"].ToString());
                a.CreateTime = DateTime.Now;
                a.State = 1;
                a.UserId = int.Parse(Request.Cookies["StudentMaster"]["UserId"].ToString());
            }
            else
            {
                a = (WinStar.Model.Ask)ViewState["a"];
            }

            a.Content = this.txtContent.Value;
            a.SubjectId = int.Parse(this.txtSubject.SelectedValue);
            a.Title = this.txtTitle.Text;

            if (ViewState["Id"].ToString() == "0")
            {
                bll.Add(a);
            }
            else
            {
                bll.Update(a);
            }
            Response.Redirect("AskList.aspx?State=0");
        }
        catch
        {
            Common.alert("操作失败，请重试！", "AskList.aspx?State=0");
        }
    }

    /// <summary>
    /// 加载学生所拥有的科目
    /// </summary>
    protected void LoadSubjectList()
    {
        try
        {
            string gid = new WinStar.BLL.Class().GetModel(int.Parse(Request.Cookies["StudentMaster"]["ClassId"].ToString())).GId.ToString(); //获取年级

            //加载年级课程关系表
            System.Data.DataTable dt = new WinStar.BLL.SubjectGrade().GetList("GId=" + gid).Tables[0];
            if (dt.Rows.Count > 0)
            {
                foreach (string SId in dt.Rows[0]["SubjectId"].ToString().Split(','))
                {
                    this.txtSubject.Items.Add(new ListItem(SubjectName(SId), SId));
                }
            }
            else
            {
                this.txtSubject.Items.Add(new ListItem("暂时没有学科", "0"));
            }
        }
        catch
        {
            Common.alert("加载失败，请重试！", "AskList.aspx?State=0");
        }
    }
    /// <summary>
    /// 通过科目ID返回科目名称
    /// </summary>
    /// <param name="id">科目ID</param>
    /// <returns></returns>
    protected string SubjectName(string id)
    {
        try
        {
            string Name = new WinStar.BLL.Subject().GetModel(int.Parse(id)).Name;
            if (Name != "")
            {
                return Name;
            }
            else
            {
                return "<font color=red>学科不存在</font>";
            }
        }
        catch
        {
            return "<font color=red>学科不存在</font>";
        }
    }
}