﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_AskList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["State"]))
            {
                ViewState["State"] = Request.QueryString["State"];
            }
            else
            {
                ViewState["State"] = "1";
            }
            this.LoadAskByCID();
        }

    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadAskByCID();
    }
    /// <summary>
    /// 截取标题
    /// </summary>
    /// <param name="title"></param>
    /// <returns></returns>
    protected object ConvertTitle(object title)
    {
        object obj = "";
        try
        {
            if (title.ToString().Length > 25)
                obj = title.ToString().Substring(0, 22) + "...";
            else
                obj = title;
        }
        catch { }
        return obj;
    }
    /// <summary>
    /// 根据班级ID加载问题列表
    /// </summary>
    protected void LoadAskByCID()
    {
        try
        {
            string sqlwhere = string.Empty;
            if (ViewState["State"].ToString() == "0")
            {
                sqlwhere = " And UserId=" + Request.Cookies["StudentMaster"]["UserId"].ToString();
            }
            else
            {
                sqlwhere = " And State=" + ViewState["State"];
            }
            DataTable dt = new WinStar.BLL.Ask().GetList(string.Format(" ClassId={0} "+ sqlwhere +" order by Id Desc", Request.Cookies["StudentMaster"]["ClassId"].ToString())).Tables[0];
            if (dt.Rows.Count > 0)
            {
                PagedDataSource pds = new PagedDataSource();
                pds.DataSource = dt.DefaultView;

                this.AspNetPager1.RecordCount = pds.Count;
                pds.AllowPaging = true;
                pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
                pds.PageSize = this.AspNetPager1.PageSize;

                this.rptAskList.DataSource = pds;
                this.rptAskList.DataBind();
            }
            else
            {
                this.tdNoDate.InnerHtml = "<center><font color=red>暂时没有答疑，<a href=\"AskAdd.aspx\">发表一个问题</a> ？</font></center>";
            }
        }
        catch { }
    }
    /// <summary>
    /// 获取学科名称
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetSujectName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Subject().GetModel(Convert.ToInt32(sid)).Name;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
    /// <summary>
    /// 获取学生姓名
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetStudentName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Student().GetModel(Convert.ToInt32(sid)).TrueName;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Redirect("AskAdd.aspx");
    }
}