﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_CheckingListManage : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadPower(); //第一步加载权限
            this.InitDateStatus(); //初始化日期状态

            if (!string.IsNullOrEmpty(Request.QueryString["date"])) //用户有日期请求
            {
                ViewState["date"] = Request.QueryString["date"];
            }
            else //默认加载当前日期日子
            {
                ViewState["date"] = DateTime.Now.ToString("yyyy-MM-dd");
            }
            this.LoadSutdent();
        }
    }
    protected void LoadPower() 
    {
        WinStar.BLL.ClassPower c = new WinStar.BLL.ClassPower();
        DataTable dt = c.GetList("ClassId=" + Session["ClassId"] + " And CheckingUserId=" + Session["UserId"] + "").Tables[0];
        if (dt.Rows.Count <= 0)
        {
            Common.alert("地址不存在，或你没有权限！");
        }
    }
    /// <summary>
    /// 加载学生
    /// </summary>
    protected void LoadSutdent()
    {
        try
        {

            WinStar.BLL.Student st = new WinStar.BLL.Student();
            DataTable dt = st.GetList("ClassId=" + Session["ClassId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.Repeater1.DataSource = dt;
                this.Repeater1.DataBind();
            }
            else
            {
                this.LoadInfo.InnerHtml = "<center>暂时没有学生，建议<a href='UserAdd.aspx?ClassId=" + Session["ClassId"] + "'>添加</a>学生！</center>";
                this.LoadInfo.Visible = true;
            }
        }
        catch { }
    }
    /// <summary>
    /// 初始化日期状态
    /// </summary>
    protected void InitDateStatus()
    {
        this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']";
        try
        {
            string sql = string.Format("select distinct convert(varchar(25),CreateDate,23) as NoteDate from HS_Checking,HS_Student where HS_Checking.UserId=HS_Student.Id And HS_Student.ClassId={0}", Session["ClassId"]);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string dateList = ",disabledDates:[";
                foreach (DataRow dr in dt.Rows)
                {
                    dateList += "'" + dr[0] + "',";
                }
                dateList = dateList.TrimEnd(',');
                dateList += "]";

                this.ltMsg.Text += dateList;

                this.ltMsg.Text += "})</script>";
            }
            else
            {
                this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>";
            }
        }
        catch { this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; }
    }
    /// <summary>
    /// 根据日期加载学生考勤
    /// </summary>
    /// <param name="date">日期</param>
    protected string LoadGroupNoteByDate(string date, string UserId)
    {
        System.Text.StringBuilder listStr = new System.Text.StringBuilder();
        try
        {
            string sqlWhere = string.Format(" UserId={0} and convert(varchar(25),CreateDate,23)='{1}'", UserId, date);
            DataTable dt = new WinStar.BLL.Checking().GetList(sqlWhere).Tables[0];

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        listStr.AppendLine("<td>");
                        listStr.AppendLine(DateTime.Parse(dr["ToTime"].ToString()).ToString("tt hh 点 mm 分"));
                        listStr.AppendLine("</td><td>");
                        listStr.AppendLine(DateTime.Parse(dr["GoTime"].ToString()).ToString("tt hh 点 mm 分"));
                        listStr.AppendLine("</td>");
                        listStr.AppendLine("<td>" + this.LoadState(int.Parse(dr["State"].ToString())) + "</td>");
                        if (dr["About"].ToString().Length > 0)
                        {
                            listStr.AppendLine("<td>");
                            listStr.AppendLine(dr["About"].ToString());
                            listStr.AppendLine("</td>");
                        }
                        else
                        {
                            listStr.AppendLine("<td>无备注</td>");
                        }
                        listStr.AppendLine("<td><a href=\"CheckingEdit.aspx?Id=" + dr["Id"] + "\">修改</a></td>");
                    }
                }
                else
                {
                    listStr.AppendLine("<td colspan='4' style=\"line-height:20px;color:red;\">" + DateTime.Parse(date).ToString("yyyy年MM月dd日") + "，没有考勤信息，点击左侧日历可查看历史考勤信息！</td><td><a href=\"CheckingAdd.aspx?UserId=" + UserId + "&date=" + date + "\" style='color:red'>添加</a></td>");
                }
            }
        }
        catch { listStr.Append("<td colspan='5' style=\"line-height:20px;color:red;\">查询出错，请重试！</td>"); }

        return listStr.ToString();
    }
    protected string LoadState(int id)
    {
        string str = string.Empty;
        try
        {
            switch (id)
            {
                case 1:
                    str = "<font color='green'>正常</font>";
                    break;
                case 2:
                    str = "<font color=#FF5555>迟到</font>";
                    break;
                case 3:
                    str = "<font color=#E036E0>早退</font>";
                    break;
                case 4:
                    str = "<font color=#0000FF>请假</font>";
                    break;
                case 5:
                    str = "<font color=#FF0000>迟到且早退</font>";
                    break;
                default:
                    str = "<font color=green>正常</font>";
                    break;
            }
        }
        catch { }

        return str;
    }

    protected void btnAccept_Click(object sender, EventArgs e)
    {
        Response.Redirect("CheckingAddAll.aspx?ClassId=" + Session["ClassId"]);
    }
}