﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_CommentList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            LoadCommentList();
        }
    }
    protected void LoadCommentList()
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            System.Data.DataTable dt = new WinStar.BLL.Comment().GetList("UserId=" + Request.Cookies["StudentMaster"]["UserId"].ToString() + " order by id desc").Tables[0];
            if (dt.Rows.Count > 0)
            {
                pds.DataSource = dt.DefaultView;
                this.AspNetPager1.RecordCount = pds.Count;
                pds.AllowPaging = true;
                pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
                pds.PageSize = AspNetPager1.PageSize;

                this.Repeater1.DataSource = pds;
                this.Repeater1.DataBind();
            }
            else {

            }
        }
        catch { }
    }
    /// <summary>
    /// 翻页事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        LoadCommentList();
    }
    /// <summary>
    /// 评语类型
    /// </summary>
    /// <param name="id">类型</param>
    /// <returns></returns>
    protected string GetTypeId(string id)
    {
        string restr = "<font color='#50CF25'>每日评语</font>";
        switch (int.Parse(id))
        {
            case 1:
                restr = "<font color='#ff0000'>学期评语</font>";
                break;
            case 2:
                restr = "<font color='#CF7A25'>每月评语</font>";
                break;
            case 3:
                restr = "<font color='#CF25CF'>每周评语</font>";
                break;
            case 4:
                restr = "<font color='#50CF25'>每日评语</font>";
                break;
            default:
                restr = "<font color='#50CF25'>每日评语</font>";
                break;
        }
        return restr;

    }
    protected string getTeacher(string id)
    {
        string restr = string.Empty;
        try
        {
            restr = new WinStar.BLL.Teacher().GetModel(int.Parse(id)).TrueName;
        }
        catch {
            restr = "<font color=red>教师信息丢失</font>";
        }
        return restr;
    }
}