﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_DiaryList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
                //删除日记
                if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
                {
                    this.DelDiary(Request.QueryString["Id"]);
                }
                this.InitDateStatus(); //初始化日期状态

                if (!string.IsNullOrEmpty(Request.QueryString["date"])) //用户有日期请求
                {
                    if (!string.IsNullOrEmpty(Request.QueryString["isjs"]))
                    {
                        Response.Write(this.LoadGroupNoteByDate(Request.QueryString["date"]));
                        Response.End();
                    }
                    else
                    {
                        this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(Request.QueryString["date"].ToString());
                    }
                }
                else //默认加载当前日期日子
                {
                    this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(DateTime.Now.ToString("yyyy-MM-dd"));
                }
        }
    }

    protected void DelDiary(string Id)
    {
        try
        {
            WinStar.BLL.Diary d = new WinStar.BLL.Diary();
            DataTable dt = d.GetList("StudentId=" + Request.Cookies["StudentMaster"]["UserId"] + " And Id=" + Id).Tables[0];
            if (dt.Rows.Count > 0)
            {
                d.Delete(int.Parse(Id));
            }
            else {

                Common.alert("日记删除失败，请重试！", "DiaryList.aspx");
            }
        }
        catch {
            Common.alert("日记删除失败，请重试！", "DiaryList.aspx");
        }
    }
    /// <summary>
    /// 初始化日期状态
    /// </summary>
    protected void InitDateStatus()
    {
        this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']";
        try
        {
            string sql = string.Format("select distinct convert(varchar(25),createTime,23) as NoteDate from HS_Diary where StudentId={0}", Request.Cookies["StudentMaster"]["UserId"]);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    string dateList = ",disabledDates:[";
                    foreach (DataRow dr in dt.Rows)
                    {
                        dateList += "'" + dr[0] + "',";
                    }
                    dateList = dateList.TrimEnd(',');
                    dateList += "]";

                    this.ltMsg.Text += dateList;

                    this.ltMsg.Text += "})</script>";
                }
                else
                {
                    this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; 
                }
            }
        }
        catch { this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; }
    }
    /// <summary>
    /// 根据日期加载学生日记
    /// </summary>
    /// <param name="date">日期</param>
    protected string LoadGroupNoteByDate(string date)
    {
        System.Text.StringBuilder listStr = new System.Text.StringBuilder();
        try
        {
            string sqlWhere = string.Format(" StudentId={0} and convert(varchar(25),createTime,23)='{1}'", Request.Cookies["StudentMaster"]["UserId"], date);
            DataTable dt = new WinStar.BLL.Diary().GetList(sqlWhere).Tables[0];

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        listStr.AppendLine("<table class=\"noteTable\">");
                        listStr.AppendLine("<tr style=\"background-color: #1EB569;Color:#fff; line-height: 30px;\"><th>");
                        listStr.AppendLine("<span><a href=\"DiaryEdit.aspx?Id=" + dr["Id"].ToString() + "\">修改日记</a> | <a href=\"DiaryList.aspx?date=" + DateTime.Parse(dr["CreateTime"].ToString()).ToString("yyyy-MM-dd") + "&Id=" + dr["Id"].ToString() + " \"  onclick=\"return confirm('确认要删除吗？');\">删除日记</a></span><b>日期：</b>" + DateTime.Parse(dr["CreateTime"].ToString()).ToString("yyyy年MM月dd日"));
                        listStr.AppendLine("<b>天气：</b>" + dr["Weather"].ToString());
                        listStr.AppendLine("<b>心情：</b>" + dr["Mood"].ToString());
                        listStr.AppendLine(dr["State"].ToString() == "0" ? "<b>权限：</b>不公开" : "<b>权限：</b>公开");
                        listStr.AppendLine("</th></tr>");
                        listStr.AppendLine("<tr style=\"border-bottom: 1px solid #DEEFFA;text-align:center\"><td style=\"line-height: 30px;\">");
                        listStr.AppendLine(dr["Title"].ToString());
                        listStr.AppendLine("</td></tr>");
                        listStr.AppendLine("<tr><td style=text-align:left;line-height:22px>");
                        listStr.AppendLine("<p class=\"noteContent\">");
                        listStr.AppendLine(dr["Content"].ToString());
                        listStr.AppendLine("</p>");
                        listStr.AppendLine("</td></tr></table>");
                    }
                }
                else
                {
                    listStr.AppendLine("<center style=\"line-height:20px;color:red;\">" + DateTime.Parse(date).ToString("yyyy年MM月dd日") + "，没有写日记，“<a href=\"DiaryAdd.aspx?date=" + DateTime.Parse(date).ToString("yyyy-MM-dd") + "\">写日记</a>”!<br />点击左侧日历可查看历史日记！</center>");
                }
            }
        }
        catch { }

        return listStr.ToString();
    }
    protected void btnAccept_Click(object sender, EventArgs e)
    {
        Response.Redirect("DiaryAdd.aspx");
    }
}