﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_DiscussAdd : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!IsPostBack)
        {
            if(!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id=0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch{}
                if(id>0)
                {
                    this.LoadGroupInfo(id);
                }
                else
                {
                    Common.alert("抱歉，您访问的页面不存在！","Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的页面不存在！","Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 确认添加按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.GroupDiscuss model = new WinStar.Model.GroupDiscuss();
                model.About = this.txtContent.Text;
                model.CreateTime = DateTime.Now;
                model.GroupId = Convert.ToInt32(Request.QueryString["id"]);
                model.ReAbout = "";
                model.UserId = Convert.ToInt32(Session["UserId"]);

                int effectCount = new WinStar.BLL.GroupDiscuss().Add(model);
                if (effectCount > 0)
                {
                    Common.alert("交流信息发布成功！","DiscussList.aspx?id="+Request.QueryString["id"]);
                }
            }
            catch { Common.alert("交流信息发布失败，请重试！"); }
        }
    }
}