﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_DiscussEdit : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["did"]))
            {
                int id = 0;
                int did = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                    did = Convert.ToInt32(Request.QueryString["did"]);
                }
                catch { }
                if (id > 0 && did >0)
                {
                    this.LoadGroupInfo(id);

                    this.LoadDiscussInfo(did);
                }
                else
                {
                    Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载交流信息内容
    /// </summary>
    /// <param name="did">交流信息Id</param>
    protected void LoadDiscussInfo(int did)
    {
        try
        {
            WinStar.Model.GroupDiscuss model = new WinStar.BLL.GroupDiscuss().GetModel(did);
            this.txtContent.Text = model.About;
        }
        catch { }
    }
    /// <summary>
    /// 保存修改按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.GroupDiscuss bll = new WinStar.BLL.GroupDiscuss();
                WinStar.Model.GroupDiscuss model = bll.GetModel(Convert.ToInt32(Request.QueryString["did"]));
                model.About = this.txtContent.Text;

                bll.Update(model);

                Common.alert("交流信息修改成功！","DiscussList.aspx?id="+Request.QueryString["id"]);
            }
            catch { Common.alert("交流信息修改失败，请重试！"); }
        }
    }
}