﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_DiscussList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["did"])) //请求的是删除操作
                {
                    int did = Convert.ToInt32(Request.QueryString["did"]);
                    bool isSuccess = this.DeleteDiscussById(did);
                    if (!isSuccess)
                    {
                        Common.alert("删除失败，请重试");
                    }
                }
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);

                this.LoadDiscussList();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "GroupList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载交流列表
    /// </summary>
    protected void LoadDiscussList()
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            string sql = string.Format("select gd.Id,gd.UserId,gd.About,gd.CreateTime,gd.ReAbout,s.TrueName StudentName from hs_groupdiscuss gd,hs_student s where s.id=gd.userid and gd.GroupId={0} order by gd.Id Desc", Request.QueryString["id"]);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt.Rows.Count > 0)
            {
                pds.DataSource = dt.DefaultView;

                this.AspNetPager1.RecordCount = pds.Count;
                pds.AllowPaging = true;
                pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
                pds.PageSize = this.AspNetPager1.PageSize;

                this.rptDiscussList.DataSource = pds;
                this.rptDiscussList.DataBind();
            }
            else
            {
                this.AspNetPager1.Visible = false;
                this.ltNoData.Text = "<font color=\"red\">暂时没有任何交流主题信息！</font>";
            }
        }
        catch { }
    }

    protected string PrintCaoZuoMsg(object Did,object reAbout,object userId)
    {
        string msg = string.Empty;
        try
        {
            if (userId.ToString() == Session["UserId"].ToString() && !string.IsNullOrEmpty(reAbout.ToString()))
            {//如果是当前学生发布的信息，并且指导老师也进行了评语回复，则不具备修改信息的权限
                msg = "<a href=\"javascript:void(0);\" onclick=\"{if(confirm('确定要删除该交流主题吗？')){location.href='DiscussList.aspx?did=" + Did + "&id=" + Request.QueryString["id"] + "'}}\">删除</a>";
            }
            if (userId.ToString() == Session["UserId"].ToString() && string.IsNullOrEmpty(reAbout.ToString()))
            {//如果是当前学生发布的信息，并且指导老师还未进行评语回复，则可以对信息进行修改
                msg = "<a href=\"DiscussEdit.aspx?id=" + Request.QueryString["id"] + "&did=" + Did + "\"><font color=\"red\">修改</font></a>&nbsp;&nbsp;<a href=\"javascript:void(0);\" onclick=\"{if(confirm('确定要删除该交流主题吗？')){location.href='DiscussList.aspx?did=" + Did + "&id=" + Request.QueryString["id"] + "'}}\">删除</a>";
            }
        }
        catch { }
        return msg;
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadDiscussList();
    }
    /// <summary>
    /// 根据通知Id删除交流主题
    /// </summary>
    /// <param name="id">要执行删除的交流主题Id</param>
    /// <returns>返回bool类型值，标识是否删除成功</returns>
    protected bool DeleteDiscussById(int id)
    {
        bool result = false;
        try
        {
            new WinStar.BLL.GroupDiscuss().Delete(id);

            result = true;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 添加交流信息按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("DiscussAdd.aspx?id="+Request.QueryString["id"]);
    }
}