﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_ExamInfoList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["SId"]))
            {
                ViewState["SId"] = Request.QueryString["SId"];
            }
            else
            {
                ViewState["SId"] = "0";
            }
            LoadSubjectList();
            LoadExamInfo();
        }
    }
    /// <summary>
    /// 加载考试信息
    /// </summary>
    protected void LoadExamInfo()
    {
        try
        {
            string sqlWhere = "";
            //判断条件(select HS_Student.Num from HS_Student Where HS_Student.Id=4)
            if (ViewState["SId"].ToString() == "0")
            {
                sqlWhere = " ExamClass IS NOT NULL and CHARINDEX('" + Request.Cookies["StudentMaster"]["ClassId"].ToString() + "',examclass)>0";
            }
            else
            {
                sqlWhere = " ExamClass IS NOT NULL and CHARINDEX('" + Request.Cookies["StudentMaster"]["ClassId"].ToString() + "',examclass)>0 And sid=" + ViewState["SId"];
            }
            sqlWhere += " Order By Id DESC";
            PagedDataSource pds = new PagedDataSource();
            System.Data.DataTable dt = new WinStar.BLL.ExamInfo().GetList(sqlWhere).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.Repeater1.DataSource = pds;
            this.Repeater1.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 翻页事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        LoadExamInfo();
    }
    /// <summary>
    /// 加载学生所拥有的科目
    /// </summary>
    protected void LoadSubjectList()
    {
        try
        {
            string gid = new WinStar.BLL.Class().GetModel(int.Parse(Request.Cookies["StudentMaster"]["ClassId"].ToString())).GId.ToString(); //获取年级

            //加载年级课程关系表
            System.Data.DataTable dt = new WinStar.BLL.SubjectGrade().GetList("GId=" + gid).Tables[0];
            if (dt.Rows.Count > 0)
            {
                System.Text.StringBuilder listStr = new System.Text.StringBuilder();
                listStr.AppendLine("<ul class=\"SubjectTab\">");

                listStr.Append("<li class=\"");
                listStr.Append(("0" == (ViewState["SId"]).ToString()) ? "selected" : "");
                listStr.Append("\"><a href=\"ExamInfoList.aspx?SId=0\">所有学科</a></li>");

                foreach (string SId in dt.Rows[0]["SubjectId"].ToString().Split(','))
                {
                    listStr.Append("<li class=\"");
                    listStr.Append((SId == (ViewState["SId"]).ToString()) ? "selected" : "");
                    listStr.Append("\"><a href=\"ExamInfoList.aspx?SId=" + SId + "\">" + SubjectName(SId) + "</a></li>");
                }
                listStr.AppendLine("</ul>");
                this.tdSubjectList.InnerHtml = listStr.ToString();
            }
            else
            {
                this.tdSubjectList.InnerHtml = "<center>管理员还未设置你所在年级的科目，请过段时间查看！</center>";
            }
        }
        catch
        {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
    /// <summary>
    /// 通过科目ID返回科目名称
    /// </summary>
    /// <param name="id">科目ID</param>
    /// <returns></returns>
    protected string SubjectName(string id)
    {
        try
        {
            string Name = new WinStar.BLL.Subject().GetModel(int.Parse(id)).Name;
            if (Name != "")
            {
                return Name;
            }
            else
            {
                return "<font color=red>学科不存在</font>";
            }
        }
        catch
        {
            return "<font color=red>学科不存在</font>";
        }
    }
    /// <summary>
    /// 获取考试排名
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string getNum(string id)
    {
        try
        {
            string restr = "<font color=red>您未参加考试</font>";
            int i = 0;
            
            string sql = "select Num from HS_Results Where Eid=" + id + " and HS_Results.Num in(select Num From HS_Student Where ClassId=" + Request.Cookies["StudentMaster"]["ClassId"].ToString() + ") and HS_Results.Eid in(select HS_ExamInfo.Id from HS_ExamInfo Where ExamClass IS NOT NULL and CHARINDEX('" + Request.Cookies["StudentMaster"]["ClassId"].ToString() + "',examclass)>0) order by mark desc ";
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            ViewState["ClassNum_" + id + ""] = dt.Rows.Count;
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    i++;
                    if (dr["Num"].ToString() == Request.Cookies["StudentMaster"]["Num"].ToString())
                    {
                        restr = "第 <font color=red>" + i + " </font>名";
                        break;
                    }
                }
            }
            return restr;
        }
        catch
        {
            return "<font color=red>请重试！</font>";
        }
    }

    /// <summary>
    /// 获取考试分数
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string getScore(string id)
    {
        string restr = string.Empty;
        try {
            restr = "<font color=green>" + WinStar.DBUtility.DbHelperSQL.GetSingle("Select Mark From HS_Results Where Num=" + Request.Cookies["StudentMaster"]["Num"].ToString() + " And Eid=" + id).ToString() + " 分</font>";
        }
        catch {
            restr = "0 分";
        }
        return restr;
    }
}