﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_GroupIndex : StudentPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid); //加载小组信息

                this.LoadGroupNoticeList(gid); //加载小组通知
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = model.Name + " 小组首页";

            WinStar.BLL.GroupComment gcbll = new WinStar.BLL.GroupComment();
            object gcComment = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select top 1 [Content] from HS_GroupComment where GroupId={0} order by Id Desc", id));

            this.ltAbout.Text = model.About;
            this.ltComment.Text = gcComment == null ? "暂无评语" : gcComment.ToString();
            object GroupLeaderId = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select top 1 UserId from HS_GroupUser where GroupId={0} and HeadMan=1", id));
            this.ltGroupLeader.Text = GroupLeaderId == null ? "暂无" : new WinStar.BLL.Student().GetModel(Convert.ToInt32(GroupLeaderId)).TrueName;
            this.ltMemberCount.Text = WinStar.DBUtility.DbHelperSQL.GetSingle(string.Format("select count(*) from HS_GroupUser where GroupId={0} and State=1", id)) + "人";
            this.ltName.Text = model.Name;
            this.ltTeacher.Text = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(model.TeacherId)).TrueName;

            this.ltGroupNoticeMore.Text = "[<a href=\"NoticeList.aspx?id=" + id + "\">更多通知</a>]";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组通知
    /// </summary>
    /// <param name="id">小组Id</param>
    private void LoadGroupNoticeList(int id)
    {
        try
        {
            string sql = string.Format("select top 5 * from HS_GroupNotice where GroupId={0} order by Id Desc", id);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            this.rptGroupNotice.DataSource = dt.DefaultView;
            this.rptGroupNotice.DataBind();
        }
        catch { }
    }
}