﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

public partial class Student_GroupList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["a"]) && !string.IsNullOrEmpty(Request.QueryString["gid"]))
            { //请求的是申请加入小组操作
                if (this.ShengQ())
                {
                    Common.alert("您已经向该兴趣小组提交加入申请，请等待审核！","GroupList.aspx");
                }
                else
                {
                    Common.alert("加入申请提交失败，请重试！");
                }
            }
            this.InitTabMenu();

            this.LoadGroupList();
        }
    }
    /// <summary>
    /// 申请加入小组
    /// </summary>
    /// <returns></returns>
    protected bool ShengQ()
    {
        bool result = false;
        try
        {
            WinStar.Model.GroupUser model = new WinStar.Model.GroupUser();
            model.GroupId = Convert.ToInt32(Request.QueryString["gid"]);
            model.HeadMan = false;
            model.State = false;
            model.UserId = Convert.ToInt32(Session["UserId"]);

            int effectCount = new WinStar.BLL.GroupUser().Add(model);
            if (effectCount > 0)
                result = true;
            else
                result = false;
        }
        catch { }

        return result;
    }
    /// <summary>
    /// 初始化Tab导航
    /// </summary>
    protected void InitTabMenu() 
    {
        StringBuilder str = new StringBuilder();
        str.AppendLine("<ul class=\"SubjectTab\">");
        if (!string.IsNullOrEmpty(Request.QueryString["g"]))
        {
            if (Request.QueryString["g"].ToString() == "1")
            {
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=1\">我加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "1";
            }
            if (Request.QueryString["g"].ToString() == "0")
            {
                str.AppendLine("<li><a href=\"GroupList.aspx?g=1\">我加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "0";
            }
            if (Request.QueryString["g"].ToString() == "3")
            {
                str.AppendLine("<li><a href=\"GroupList.aspx?g=1\">我加入的小组</a></li>");
                str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
                str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

                this.hidG.Value = "3";
            }
        }
        else
        {
            str.AppendLine("<li class=\"selected\"><a href=\"GroupList.aspx?g=1\">我加入的小组</a></li>");
            str.AppendLine("<li><a href=\"GroupList.aspx?g=3\">申请加入的小组</a></li>");
            str.AppendLine("<li><a href=\"GroupList.aspx?g=0\">其他小组</a></li>");

            this.hidG.Value = "1";
        }
        str.AppendLine("</ul>");

        this.ltTabMenu.Text = str.ToString();
    }
    /// <summary>
    /// 加载兴趣小组列表
    /// </summary>
    protected void LoadGroupList()
    {
        try
        {
            string sql = string.Empty;
            if (!string.IsNullOrEmpty(Request.QueryString["g"]))
            {
                if (Request.QueryString["g"].ToString() == "1")
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=1", Session["UserId"]);
                }
                if (Request.QueryString["g"].ToString() == "3") //加载申请审核中的小组
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=0", Session["UserId"]);
                }
                if (Request.QueryString["g"].ToString() == "0") //加载其他兴趣小组
                {
                    sql = string.Format("select g.Id GroupId,g.Name GroupName,g.CreateTime,t.TrueName,g.TeacherId,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount from hs_group g,hs_teacher t where g.Id not in (select groupId from hs_groupUser where userId={0}) and t.Id=g.TeacherId order by MemberCount,g.CreateTime Desc", Session["UserId"]);
                }
            }
            else //默认则加载我加入的兴趣小组
            {
                sql = string.Format("select g.Id GroupId,g.Name GroupName,g.TeacherId,g.CreateTime,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,t.TrueName from hs_groupuser gu,hs_group g,hs_Teacher t where gu.GroupId=g.id and UserId={0} and t.Id=g.TeacherId and gu.state=1", Session["UserId"]);
            }

            PagedDataSource pds = new PagedDataSource();
            System.Data.DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptGroupList.DataSource = pds;
            this.rptGroupList.DataBind();
            
        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupList();
    }
}