﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_GroupMsg : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                try
                {
                    int id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');self.close();</script>"); }
                this.LoadGroupInfo();
            }
            else
            {
                Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');self.close();</script>");
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    protected void LoadGroupInfo()
    {
        try
        {
            string sql = string.Format("select g.Name GroupName,g.About,g.CreateTime,t.TrueName TeacherName,(select count(*) from hs_groupUser where GroupId=g.Id and State=1) MemberCount,(select top 1 s.TrueName from hs_groupUser gu,hs_student s where s.Id=gu.UserId and gu.GroupId=g.Id and gu.State=1 and gu.HeadMan=1) GroupLeader from hs_group g,hs_teacher t where g.id={0} and t.Id=g.TeacherId", Request.QueryString["id"]);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.LoadComment();
                this.ltCreateTime.Text = DateTime.Parse(dt.Rows[0]["CreateTime"].ToString()).ToString("yyyy年MM月dd日");
                this.ltDesc.Text = dt.Rows[0]["About"].ToString();
                if (DBNull.Value == dt.Rows[0]["GroupLeader"])
                {
                    this.ltGroupLeader.Text = "暂无";
                }
                else
                {
                    this.ltGroupLeader.Text = dt.Rows[0]["GroupLeader"].ToString();
                }
                
                this.ltGroupName.Text = dt.Rows[0]["GroupName"].ToString();
                this.ltMemberCount.Text = dt.Rows[0]["MemberCount"].ToString();
                this.ltTeacher.Text = dt.Rows[0]["TeacherName"].ToString();
                this.ltTitle.Text = dt.Rows[0]["GroupName"].ToString() + "&nbsp;&nbsp;&nbsp;小组信息";
            }
            else
            {
                Response.Write("<script type='text/javascript'>alert('抱歉，您访问的地址不存在！');self.close();</script>");
            }
        }
        catch { }
    }
    /// <summary>
    /// 加载评语
    /// </summary>
    protected void LoadComment()
    {
        try
        {
            string sql = string.Format("select top 1 Content from hs_groupComment where GroupId={0} order by Id Desc",Request.QueryString["id"]);
            this.ltComment.Text = WinStar.DBUtility.DbHelperSQL.GetSingle(sql).ToString();
        }
        catch { this.ltComment.Text = "暂无"; }
    }
}