﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class Student_HomeWorkAdd : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(Request.QueryString["Id"]))
        {
            ViewState["Id"] = Request.QueryString["Id"];
            this.LoadHomeWork();
        }
        else
        {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
    /// <summary>
    /// 加载家庭作业信息
    /// </summary>
    protected void LoadHomeWork()
    {
        try {
            System.Text.StringBuilder listStr = new System.Text.StringBuilder();
            WinStar.Model.HomeWork h = new WinStar.BLL.HomeWork().GetModel(int.Parse(ViewState["Id"].ToString()));

            listStr.Append("<table width=98%  style=\"border:1px solid #32CB6F;\"><tr><td style='line-height:30px;width:30%;padding-left:10px;' valign=top>");
            listStr.Append("<b>&nbsp;&nbsp;布&nbsp;置&nbsp;时&nbsp;间&nbsp;&nbsp;：</b>" + DateTime.Parse(h.CreateTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("<br/><b>要求完成时间：</b>" + DateTime.Parse(h.EndTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("</td><td style='text-align:left' valign=top>");
            listStr.Append("<b>作业内容：</b>" + h.Content);
            listStr.Append("</td></tr></table>");
            ViewState["SId"] = h.SubjectId;

            this.tdHomeWork.InnerHtml = listStr.ToString();
        }
        catch {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
    protected void btn2_Click(object sender, EventArgs e)
    {
        try
        {
            string PicURL = string.Empty;
            if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
            {
                string filename1 = FileUpload1.PostedFile.FileName;
                string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                if (ext.ToLower() == ".exe" && ext.ToLower() == ".bat" && ext.ToLower() == ".reg")
                {
                    Response.Write("<script>alert('文件格式不支持.EXE、.BAT、.REG等格式。');history.back(-1);</script>");
                    return;
                }
                else
                {
                    string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                    string path = Server.MapPath(@"..\UploadFile\student\" + Request.Cookies["StudentMaster"]["Num"].ToString() + "\\");
                    if (!Directory.Exists(path))
                    {
                        Directory.CreateDirectory(path);
                    }
                    string fpath = path + filename2 + ext;
                    FileUpload1.SaveAs(fpath);
                    PicURL = "UploadFile/student/" + Request.Cookies["StudentMaster"]["Num"].ToString() + "/" + filename2 + ext;
                }
            }

            WinStar.Model.SubmitWork d = new WinStar.Model.SubmitWork();
            d.UserId = Request.Cookies["StudentMaster"]["UserId"].ToString();
            d.CreateTime = DateTime.Now;
            d.State = 1;
            d.HomeWorkId = int.Parse(ViewState["Id"].ToString());
            d.Content = this.txtContent.Value;
            d.FileUrl = PicURL;
            int num = new WinStar.BLL.SubmitWork().Add(d);
            if (num > 0)
            {
                Response.Redirect("HomeWorkList.aspx?SId=" + ViewState["SId"]);
            }
            else
            {
                Common.alert("作业提交失败，请重试！", "HomeWorkList.aspx");
            }
        }
        catch
        {
            Common.alert("作业提交失败，请重试！", "HomeWorkList.aspx");
        }
    }
}