﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_NoteAdd : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id > 0)
                {
                    this.LoadGroupInfo(id);
                }
                else
                {
                    Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 添加按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.GroupNote model = new WinStar.Model.GroupNote();
                model.Content = this.txtContent.Value;
                model.CreateTime = DateTime.Now;
                model.GroupId = Convert.ToInt32(Request.QueryString["id"]);
                model.Hits = 0;
                model.Title = this.txtTitle.Text;
                model.UserId = Convert.ToInt32(Session["UserId"]);

                int effectCount = new WinStar.BLL.GroupNote().Add(model);
                if (effectCount > 0)
                {
                    Common.alert("学习笔记添加成功！", "NoteList.aspx?id=" + Request.QueryString["id"]);
                }
                else
                {
                    Common.alert("学习笔记添加失败，请重试！");
                }
            }
            catch { Common.alert("学习笔记添加失败，请重试！"); }
        }
    }
}