﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_NoteEdit : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["nid"]))
            {
                int id = 0;
                int nid = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);

                    nid = Convert.ToInt32(Request.QueryString["nid"]);
                }
                catch { }
                if (id > 0 && nid > 0)
                {
                    this.LoadGroupInfo(id);

                    this.LoadNoteInfo(nid);
                }
                else
                {
                    Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的页面不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载笔记信息
    /// </summary>
    /// <param name="id">笔记Id</param>
    protected void LoadNoteInfo(int id)
    {
        try
        {
            WinStar.Model.GroupNote model = new WinStar.BLL.GroupNote().GetModel(id);
            this.txtContent.Value = model.Content;
            this.txtTitle.Text = model.Title;
        }
        catch { }
    }
    /// <summary>
    /// 保存修改按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.GroupNote bll = new WinStar.BLL.GroupNote();

                WinStar.Model.GroupNote model = bll.GetModel(Convert.ToInt32(Request.QueryString["nid"])); ;
                model.Content = this.txtContent.Value;
                model.Title = this.txtTitle.Text;

                bll.Update(model);

                Common.alert("学习笔记修改成功！", "NoteList.aspx?id=" + Request.QueryString["id"]);
            }
            catch { Common.alert("学习笔记修改失败，请重试！"); }
        }
    }
}