﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_NoteList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["nid"])) //用户请求的是删除操作
                {
                    if (!this.DelNoteById(Request.QueryString["nid"]))
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.hGid.Value = gid.ToString();

                this.LoadGroupInfo(gid); //加载小组信息

                this.InitDateStatus(gid); //初始化日期状态

                if (!string.IsNullOrEmpty(Request.QueryString["date"])) //用户有日期请求
                {
                    Response.Write(this.LoadGroupNoteByDate(Request.QueryString["date"], gid));
                    Response.End();
                }
                else //默认加载当前日期日子
                {
                    this.tdNoteList.InnerHtml = this.LoadGroupNoteByDate(DateTime.Now.ToString("yyyy-MM-dd"), gid);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 初始化日期状态
    /// </summary>
    /// <param name="id">小组Id</param>
    protected void InitDateStatus(int id)
    {
        this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:aa,opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']";
        try
        {
            string sql = string.Format("select distinct convert(varchar(25),createTime,23) as NoteDate from HS_groupNote where groupId={0}", id);

            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];
            if (dt.Rows.Count > 0)
            {
                string dateList = ",disabledDates:[";
                foreach (DataRow dr in dt.Rows)
                {
                    dateList += "'" + dr[0] + "',";
                }
                dateList = dateList.TrimEnd(',');
                dateList += "]";

                this.ltMsg.Text += dateList;

                this.ltMsg.Text += "})</script>";
            }
            else
            {
                this.ltMsg.Text += ",disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']})</script>";
            }
        }
        catch { this.ltMsg.Text = "<script>WdatePicker({eCont: 'div1',onpicked:function(dp){alert('你选择的日期是:'+dp.cal.getDateStr())},opposite:true,specialDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "'],disabledDates:['" + DateTime.Now.ToString("yyyy-MM-dd") + "']});</script>"; }
    }
    /// <summary>
    /// 根据日期加载学习笔记
    /// </summary>
    /// <param name="date">日期</param>
    /// <param name="gid">小组id</param>
    protected string LoadGroupNoteByDate(string date, int gid)
    {
        System.Text.StringBuilder listStr = new System.Text.StringBuilder();
        try
        {
            string sql = string.Format("select gn.Id,gn.GroupId,gn.UserId,gn.Title,gn.Content,gn.CreateTime,gn.Hits,gs.TrueName from hs_groupNote gn,hs_Student gs where gn.groupId={0} and gs.Id = gn.UserId and convert(varchar(25),createTime,23)='{1}'", gid, date);
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        listStr.AppendLine("<table class=\"noteTable\">");
                        listStr.AppendLine("<tr class=\"header\"><th>");
                        listStr.AppendLine("<label>学生姓名：</label>" + dr["TrueName"] + "&nbsp;&nbsp;<label>日期：</label>" + DateTime.Parse(dr["CreateTime"].ToString()).ToString("yyyy年MM月dd日") + this.ActionValidate(dr["UserId"], dr["Id"]));
                        listStr.AppendLine("</th></tr>");
                        listStr.AppendLine("<tr style=\"border-bottom: 1px solid #1EB569;\"><td style=\"line-height: 30px;\">");
                        listStr.AppendLine("<label class=\"Masthead\">标题：</label>" + dr["Title"]);
                        listStr.AppendLine("</td></tr>");
                        listStr.AppendLine("<tr><td>");
                        listStr.AppendLine("<label class=\"Masthead\">笔记内容：</label><br />");
                        listStr.AppendLine("<p class=\"noteContent\">");
                        listStr.AppendLine(dr["Content"].ToString());
                        listStr.AppendLine("</p>");
                        listStr.AppendLine("</td></tr></table>");
                    }
                }
                else
                {
                    listStr.AppendLine("<center style=\"line-height:30px;color:red;\">" + DateTime.Parse(date).ToString("yyyy年MM月dd日") + "，今天没有本小组成员的学习笔记!<br />点击左侧日历可查看其它日期的学习笔记！</center>");
                }
            }
        }
        catch { }

        return listStr.ToString();
    }
    /// <summary>
    /// 删除笔记
    /// </summary>
    /// <param name="id">笔记ID</param>
    /// <returns></returns>
    private bool DelNoteById(object id)
    {
        bool result = false;
        try
        {
            new WinStar.BLL.GroupNote().Delete(Convert.ToInt32(id));
            result = true;
        }
        catch { result = false; }
        return result;
    }

    private object ActionValidate(object userId,object nid)
    {
        object str = "";
        if (userId.ToString() == Session["UserId"].ToString())
        {
            object date = "";
            if (!string.IsNullOrEmpty(Request.QueryString["date"]))
                date = Request.QueryString["date"];
            else
                date = DateTime.Now.ToShortDateString();

            str = "<span><a href=\"NoteEdit.aspx?id=" + Request.QueryString["id"] + "&nid=" + nid + "\">修改笔记</a> | <a href=\"NoteList.aspx?id=" + Request.QueryString["id"] + "&nid=" + nid + "&date=" + date + "\" onclick=\"{if(confirm('您确定要删除当前学习笔记吗？')){return ture;}return false;}\">删除笔记</a></span>";
        }
        return str;
    }
    /// <summary>
    /// 添加学习笔记按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("NoteAdd.aspx?id="+Request.QueryString["id"]);
    }
}