﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_NoticeList : StudentPageBase
{
    protected string GroupIndexInfo = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {                
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);

                this.LoadNoticeList();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.GroupIndexInfo = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
            this.ltGroupInfo.Text = this.GroupIndexInfo;
        }
        catch { }
    }
    /// <summary>
    /// 加载小组通知
    /// </summary>
    protected void LoadNoticeList()
    {
        try
        {
            WinStar.BLL.GroupNotice bll = new WinStar.BLL.GroupNotice();

            PagedDataSource pds = new PagedDataSource();

            string sqlWhere = string.Format(" GroupId={0} order by CreateTime Desc", Request.QueryString["id"]);
            DataTable dt = bll.GetList(sqlWhere).Tables[0];

            dt.Columns.Add("Num");
            for (int i = 0; i < dt.Rows.Count;i++ )
            {
                dt.Rows[i]["Num"] = i + 1;
            }

            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptNoticeList.DataSource = pds;
            this.rptNoticeList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadNoticeList();
    }
}