﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Student_NoticesEdit : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (this.ValidatePower())
            {
                if (!string.IsNullOrEmpty(Request.QueryString["id"]))
                {
                    this.LoadNoticeInfo();
                }
                else
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在或您没有权限访问！","Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载公告信息
    /// </summary>
    private void LoadNoticeInfo()
    {
        try
        {
            WinStar.BLL.Notice n = new WinStar.BLL.Notice();
            WinStar.Model.Notice mn = n.GetModel(int.Parse(Request["id"].ToString()));
            ViewState["Nid"] = Request["id"].ToString();
            this.title.Text = mn.Title;
            this.Summary.Value = mn.Content;
        }
        catch { }
    }
    /// <summary>
    /// 验证权限
    /// </summary>
    /// <returns></returns>
    protected bool ValidatePower()
    {
        bool result = false;
        try
        {
            WinStar.BLL.ClassPower c = new WinStar.BLL.ClassPower();
            DataTable dt = c.GetList("ClassId=" + Session["ClassId"] + " And NoticeUserId=" + Session["UserId"] + "").Tables[0];
            
            if (dt.Rows.Count > 0)
                result = true;
        }
        catch { }
        return result;
    }
  
    protected void btn2_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                string title = this.title.Text;
                string content = this.Summary.Value;
                WinStar.BLL.Notice n = new WinStar.BLL.Notice();
                WinStar.Model.Notice m = n.GetModel(int.Parse(ViewState["Nid"].ToString()));
                m.Title = title;
                m.Content = content;
                
                n.Update(m);

                Common.alert("修改成功！", "NoticesList.aspx");
            }
            catch { Common.alert("修改失败，请重试！"); }
        }
    }
}