﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class Student_PicAdd : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 开始上传按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpload_Click(object sender, EventArgs e)
    {
        try
        {
            lblMessage.Text = "";
            lblMessage.Visible = false;

            System.Collections.Hashtable table = new System.Collections.Hashtable(); //存储于数据库sql语句集合

            System.Web.HttpFileCollection files = System.Web.HttpContext.Current.Request.Files;
            System.Text.StringBuilder strmsg = new System.Text.StringBuilder("");
            string[] picDescArray = Request.Form[2].Split(',');//获得图片描述的文本框字符串数组，为对应的图片的描述

            int ifile;
            int hasFileCount = 0;
            for (ifile = 0; ifile < files.Count; ifile++)
            {
                if (files[ifile].FileName.Length > 0) //检测上传控件中是否包含图片文件
                {
                    System.Web.HttpPostedFile postedfile = files[ifile];
                    if (postedfile.ContentLength / 1024 > 1024)//单个文件不能大于1024k
                    {
                        strmsg.Append(Path.GetFileName(postedfile.FileName) + "---图片大小不能超过1024KB！<br>");
                        break;
                    }
                    string fex = Path.GetExtension(postedfile.FileName);
                    if (fex.ToLower() != ".jpg" && fex.ToLower() != ".gif" && fex.ToLower() != ".jpe" && fex.ToLower() != ".jpeg" && fex.ToLower() != ".bmp" && fex.ToLower() != ".bmp")
                    {
                        strmsg.Append(Path.GetFileName(postedfile.FileName) + "---图片格式只能是jpg、gif、jpe、jpeg、bmp和png！<br>");
                        break;
                    }
                    hasFileCount++;
                }
            }
            if (hasFileCount == 0)
            {
                lblMessage.Text = "您没有选择任何图片文件进行上传！";
                lblMessage.Visible = true;
            }
            else
            {
                if (strmsg.Length <= 0)    //说明图片大小和格式都没问题
                {
                    //以下为创建图库目录
                    string dirpath = Server.MapPath("/UpLoadFiles/GroupFiles/GroupPic/" + Request.QueryString["id"] + "/");

                    if (!Directory.Exists(dirpath))
                    {
                        Directory.CreateDirectory(dirpath);
                    }
                    Random ro = new Random();
                    int name = 1;
                    for (int i = 0; i < files.Count; i++)
                    {
                        System.Web.HttpPostedFile myFile = files[i];
                        string FileName = "";
                        string FileExtention = "";
                        FileName = System.IO.Path.GetFileName(myFile.FileName);
                        string stro = ro.Next(100, 100000000).ToString() + name;//产生一个随机数用于新命名的图片
                        string NewName = DateTime.Now.ToString("yyyyMMddHHmmms") + stro;
                        if (FileName.Length > 0)//有文件才执行上传操作再保存到数据库
                        {
                            FileExtention = System.IO.Path.GetExtension(myFile.FileName);
                            string ppath = dirpath + @"" + NewName + FileExtention;
                            myFile.SaveAs(ppath);

                            //UserId暂时默认为1
                            table.Add(string.Format("insert into HS_GroupPic (GroupId,UserId,PicUrl,About,CreateTime) values ({0},{1},'{2}','{3}','{4}')", Convert.ToInt32(Request.QueryString["id"]), 1, "/UpLoadFiles/GroupFiles/GroupPic/" + Request.QueryString["id"] + "/" + NewName + FileExtention, picDescArray[i], DateTime.Now.ToString()), null);

                        }
                        name = name + 1;//用来重命名规则的变量
                    }

                    bool result = this.AddPic(table);
                    if (result)
                        Common.alert("图片上传成功！", "PicList.aspx?id=" + Request.QueryString["id"]);
                    else
                        Common.alert("上传失败，请重试！");
                }
                else
                {
                    lblMessage.Text = strmsg.ToString();
                    lblMessage.Visible = true;
                }
            }
        }
        catch { Common.alert("上传失败，请重试！"); }
    }
    /// <summary>
    /// 将图片信息插入到数据库中
    /// </summary>
    /// <param name="table">执行的sql语句集合，HashTable类型</param>
    /// <returns></returns>
    protected bool AddPic(System.Collections.Hashtable table)
    {
        bool result = false;
        try
        {
            WinStar.DBUtility.DbHelperSQL.ExecuteSqlTran(table);

            result = true;
        }
        catch { }
        return result;
    }
}