﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Student_PicList : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid); //加载小组信息

                this.LoadGroupPicList(gid); //加载共享图片
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组共享图片列表
    /// </summary>
    /// <param name="gid">小组Id</param>
    protected void LoadGroupPicList(int gid)
    {
        try
        {
            PagedDataSource pds = new PagedDataSource();
            DataTable dt = new WinStar.BLL.GroupPic().GetList(string.Format(" GroupId={0} order by Id Desc", gid)).Tables[0];

            pds.DataSource = dt.DefaultView;
            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptPicList.DataSource = pds;
            this.rptPicList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadGroupPicList(Convert.ToInt32(Request.QueryString["id"]));
    }
    /// <summary>
    /// 我要上传按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpLoadImg_Click(object sender, EventArgs e)
    {
        Response.Redirect("PicAdd.aspx?id=" + Request.QueryString["id"]);
    }
}