﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

public partial class Student_SubmitWorkEdit : StudentPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["Id"]) && !string.IsNullOrEmpty(Request.QueryString["SumbitId"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["Action"]))
                {
                    this.DeleteFile(Request.QueryString["Id"], Request.QueryString["SumbitId"]);
                }
                ViewState["Id"] = Request.QueryString["Id"];  //作业ID
                ViewState["SumbitId"] = Request.QueryString["SumbitId"]; //作业提交表ID
                this.LoadHomeWork();
            }
            else
            {
                Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
            }
        }
    }
    /// <summary>
    /// 加载家庭作业信息和提交的作业信息
    /// </summary>
    protected void LoadHomeWork()
    {
        try
        {
            //加载作业信息
            System.Text.StringBuilder listStr = new System.Text.StringBuilder();
            WinStar.Model.HomeWork h = new WinStar.BLL.HomeWork().GetModel(int.Parse(ViewState["Id"].ToString()));

            listStr.Append("<table width=98%  style=\"border:1px solid #32CB6F;\"><tr><td style='line-height:30px;width:30%;padding-left:10px;' valign=top>");
            listStr.Append("<b>&nbsp;&nbsp;布&nbsp;置&nbsp;时&nbsp;间&nbsp;&nbsp;：</b>" + DateTime.Parse(h.CreateTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("<br/><b>要求完成时间：</b>" + DateTime.Parse(h.EndTime.ToString()).ToString("yy年MM月dd日"));
            listStr.Append("</td><td style='text-align:left' valign=top>");
            listStr.Append("<b>作业内容：</b>" + h.Content);
            listStr.Append("</td></tr></table>");
            ViewState["SId"] = h.SubjectId;

            this.tdHomeWork.InnerHtml = listStr.ToString();

            //加载提交的作业信息
            System.Data.DataTable dt = new WinStar.BLL.SubmitWork().GetList("UserId=" + Request.Cookies["StudentMaster"]["UserId"].ToString() + " And Id=" + ViewState["SumbitId"]).Tables[0];
            if (dt.Rows.Count > 0)
            {
                this.txtContent.Value = dt.Rows[0]["Content"].ToString();
                if (!string.IsNullOrEmpty(dt.Rows[0]["FileUrl"].ToString()))
                {
                    this.FileUrl.Visible = true;
                    this.FileUrl.InnerHtml = "<a href='" + Common.getUrl() + dt.Rows[0]["FileUrl"].ToString() + "' target='_blank'>下载附件</a> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a href='javascript:' onclick=\"{if(confirm('确认删除此附件吗?')){aa('" + dt.Rows[0]["HomeWorkId"].ToString() + "','" + dt.Rows[0]["Id"].ToString() + "');}return false;}\">删除</a>";
                }
                //如果已经批改就不让修改
                if (dt.Rows[0]["State"].ToString() == "2")
                {
                    this.Button1.Enabled = false;
                    this.FileUpload1.Enabled = false;
                    if (!string.IsNullOrEmpty(dt.Rows[0]["FileUrl"].ToString()))
                    {
                        this.FileUrl.Visible = true;
                        this.FileUrl.InnerHtml = "<a href='" + Common.getUrl() + dt.Rows[0]["FileUrl"].ToString() + "' target='_blank'>下载附件</a> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;删除";
                    }
                }

            }
            else {
                Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
            }

        }
        catch
        {
            Common.alert("加载失败，请重试！", "HomeWorkList.aspx");
        }
    }
    protected void DeleteFile(string hid,string sid)
    {
        try
        {
            WinStar.Model.SubmitWork d = new WinStar.Model.SubmitWork();
            d = new WinStar.BLL.SubmitWork().GetModel(int.Parse(sid)); //预加载信息

            if (File.Exists(Server.MapPath(@"/" + d.FileUrl)))//如果该文件存在，则删除
            {
                File.Delete(Server.MapPath(@"/" + d.FileUrl));
            }

            d.FileUrl = "";
            new WinStar.BLL.SubmitWork().Update(d);
            Response.Write(1);
            Response.End();
        }
        catch {
            
        }
    }
    /// <summary>
    /// 修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btn2_Click(object sender, EventArgs e)
    {
        try
        {
            string PicURL = string.Empty;
            WinStar.Model.SubmitWork d = new WinStar.Model.SubmitWork();
            d = new WinStar.BLL.SubmitWork().GetModel(int.Parse(ViewState["SumbitId"].ToString())); //预加载信息
            if (!string.IsNullOrEmpty(this.FileUpload1.PostedFile.FileName))
            {
                string filename1 = FileUpload1.PostedFile.FileName;
                string ext = filename1.Substring(filename1.LastIndexOf(".")).ToLower();
                if (ext.ToLower() == ".exe" && ext.ToLower() == ".bat" && ext.ToLower() == ".reg")
                {
                    Response.Write("<script>alert('文件格式不支持.EXE、.BAT、.REG等格式。');history.back(-1);</script>");
                    return;
                }
                else
                {
                    string filename2 = DateTime.Now.ToString("yyyyMMddhhmmss");
                    string path = Server.MapPath(@"..\UploadFile\student\" + Request.Cookies["StudentMaster"]["Num"].ToString() + "\\");
                    if (!Directory.Exists(path))
                    {
                        Directory.CreateDirectory(path);
                    }
                    string fpath = path + filename2 + ext;
                    FileUpload1.SaveAs(fpath);
                    PicURL = "UploadFile/student/" + Request.Cookies["StudentMaster"]["Num"].ToString() + "/" + filename2 + ext;

                    //修改附件数据库信息前把之前的附件删除掉
                    if (File.Exists(Server.MapPath(@"/" + d.FileUrl)))//如果该文件存在，则删除
                    {
                        File.Delete(Server.MapPath(@"/" + d.FileUrl));
                    }

                    d.FileUrl = PicURL;
                }
            }

            d.Content = this.txtContent.Value;
            new WinStar.BLL.SubmitWork().Update(d);
            Response.Redirect("HomeWorkList.aspx?SId=" + ViewState["SId"]);
        }
        catch
        {
            Common.alert("作业修改失败，请重试！", "HomeWorkList.aspx");
        }
    }
}