﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_AskAnswer : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int id = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                }
                catch { }
                if (id != 0)
                {
                    this.LoadAskInfo(id);

                    this.LoadAnswerList(id);
                }
                else
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx",1);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载问题信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadAskInfo(int id)
    {
        try
        {
            WinStar.Model.Ask model = new WinStar.BLL.Ask().GetModel(id);
            this.ltAskMsg.Text = "提问学生："+this.GetStudentName(model.UserId)+"&nbsp;&nbsp;&nbsp;提问时间："+DateTime.Parse(model.CreateTime.ToString()).ToString("yyyy-MM-dd HH:mm");
            this.ltAskContent.Text = model.Content;
            this.ltAskState.Text = model.State.ToString() == "1" ? "<span class=\"NoSolve\"></span>待解决" : "<span class=\"Solved\"></span>已解决";
            this.ltAskTitle.Text = model.Title;
            if (model.State.ToString() == "2") //如果问题已解决，则隐藏回答框
            {
                this.tblAnsewer.Style["display"] = "none";
                this.LoadBestAnswer(id);
            }
            else
            {
                this.tblBestAnswer.Style["display"] = "none";
            }
        }
        catch { }
    }
    /// <summary>
    /// 加载回答列表
    /// </summary>
    /// <param name="answerId">问题id</param>
    protected void LoadAnswerList(int answerId)
    {
        try
        {
            string sqlWhere = string.Format(" AskId={0}", answerId);
            this.ltAnswerTitleMsg.Text = "回答";
            if (!string.IsNullOrEmpty(this.hidBestAskId.Value.ToString()))
            {
                sqlWhere = string.Format(" AskId={0} and Id != {1}", answerId,Convert.ToInt32(this.hidBestAskId.Value));
                this.ltAnswerTitleMsg.Text = "其它回答";
            }
            System.Data.DataTable dt = new WinStar.BLL.AskAnswer().GetList(sqlWhere).Tables[0];

            this.ltAnswerCount.Text = "<font style=\"font-size:12px;font-weight:normal;\">共 " + dt.Rows.Count + " 条</font>";

            this.rptAnswerList.DataSource = dt;
            this.rptAnswerList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载最佳答案
    /// </summary>
    /// <param name="id">问题Id</param>
    protected void LoadBestAnswer(int id)
    {
        try
        {
            System.Data.DataTable dt = new WinStar.BLL.AskAnswer().GetList(string.Format(" isbest=1 and askid={0}",id)).Tables[0];

            this.ltBestAnswerContent.Text = dt.Rows[0]["Content"].ToString();
            this.ltBestAnswerMsg.Text = "回答者："+ (dt.Rows[0]["UserType"].ToString() == "1" ? this.GetTeacherName(dt.Rows[0]["UserId"]) + "老师" : this.GetStudentName(dt.Rows[0]["UserId"]) + "同学")+"&nbsp;&nbsp;&nbsp;回答时间：" + DateTime.Parse(dt.Rows[0]["CreateTime"].ToString()).ToString("yyyy-MM-dd HH:mm");
            this.hidBestAskId.Value = dt.Rows[0]["Id"].ToString();
        }
        catch { }
    }
    /// <summary>
    /// 获取学生姓名
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetStudentName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Student().GetModel(Convert.ToInt32(sid)).TrueName;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
    /// <summary>
    /// 获取老师姓名
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetTeacherName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(sid)).TrueName;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.AskAnswer model = new WinStar.Model.AskAnswer();
                model.AskId = Convert.ToInt32(Request.QueryString["id"]);
                model.Content = this.txtAnswerContent.Text;
                model.CreateTime = DateTime.Now;
                model.IsBest = false;
                model.Title = "";
                model.UserId = Convert.ToInt32(Session["TeacherId"]);
                model.UserType = 1;

                int effectCount = new WinStar.BLL.AskAnswer().Add(model);
                if (effectCount > 0)
                {
                    Common.alert("回答提交成功！", "AskAnswer.aspx?id=" + Request.QueryString["id"]);
                }
                else
                {
                    Common.alert("回答提交失败，请重试！");
                }
            }
            catch { Common.alert("回答提交失败，请重试！"); }
        }
    }
}