﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_AskList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.LoadTeacherClass();

            this.LoadAskByCID();
        }
    }
    /// <summary>
    /// 根据班级ID加载问题列表
    /// </summary>
    protected void LoadAskByCID()
    {
        try
        {
            DataTable dt = new WinStar.BLL.Ask().GetList(string.Format(" ClassId={0} order by Id Desc", Convert.ToInt32(this.hidClassId.Value))).Tables[0];

            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptAskList.DataSource = pds;
            this.rptAskList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 加载班级列表
    /// </summary>
    protected void LoadTeacherClass()
    {
        string str = string.Empty;
        try
        {
            string sql = string.Format("select distinct ClassId from hs_teachersubject where teacherid={0} order by ClassId", Convert.ToInt32(Session["TeacherId"]));
            DataTable dt = WinStar.DBUtility.DbHelperSQL.Query(sql).Tables[0];

            if (dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    int CID = Convert.ToInt32(dt.Rows[i]["ClassId"]);
                    string CName = this.GetCname(CID);
                    if (CName != "<font color=red>已经毕业</font>" && CName != "<font color=red>还没开学</font>")
                    {
                        object classNum = new WinStar.BLL.Class().GetModel(CID).ClassNum;
                        if (!string.IsNullOrEmpty(Request.QueryString["cid"]))
                        {
                            this.hidClassId.Value = Request.QueryString["cid"];
                        }
                        else
                        {
                            if (i == 0)
                            {
                                this.hidClassId.Value = CID.ToString();
                            }
                        }
                        str += "<a href=\"AskList.aspx?cid=" + CID + "\" class=\"aCss\"><div id=\"divClass" + CID + "\">" + CName + "(" + classNum + ")班" + "</div></a>";
                    }
                }
            }
            else
            {
                //该科任老师没有执教任何班级
            }
        }
        catch { }
        this.ltClassList.Text = str;
    }
    
    protected string Temp(int num)
    {
        string str = string.Empty;
        try
        {
            switch (num)
            {
                case 1:
                    str = "一";
                    break;
                case 2:
                    str = "二";
                    break;
                case 3:
                    str = "三";
                    break;
                case 4:
                    str = "四";
                    break;
                case 5:
                    str = "五";
                    break;
                case 6:
                    str = "六";
                    break;
                case 7:
                    str = "七";
                    break;
                case 8:
                    str = "八";
                    break;
                case 9:
                    str = "九";
                    break;
            }
        }
        catch { }

        return str;
    }
    /// <summary>
    /// 获取班级名称
    /// </summary>
    /// <param name="classID">获取班级Id</param>
    /// <returns></returns>
    protected string GetCname(int classID)
    {
        string yein = "";
        int isgrade = 0;
        WinStar.Model.Class sclass = new WinStar.BLL.Class().GetModel(classID);
        int gid = Convert.ToInt32(sclass.GId);
        WinStar.Model.Grade grade = new WinStar.BLL.Grade().GetModel(gid);
        yein = grade.YearIn.ToString();
        isgrade = Convert.ToInt32(grade.TypeAge);
        return GetGradeName(yein, isgrade);
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="yein">入学年份</param>
    /// <param name="isgrade">学段</param>
    /// <returns></returns>
    protected string GetGradeName(string yein, int isgrade)
    {
        int nowterm;//当前学期年份
        bool onetwo;//当前学期是第一学期还是第二学期
        DataTable dt = new WinStar.BLL.Term().GetList("IsNow=1").Tables[0];
        if (dt.Rows.Count > 0)
        {
            nowterm = DateTime.Parse(dt.Rows[0]["StartTime"].ToString()).Year;
            onetwo = Boolean.Parse(dt.Rows[0]["OneOrTwo"].ToString());
            return GetHowGrade(nowterm, int.Parse(yein), onetwo, isgrade);

        }
        else
        {
            return "<font color=\"red\">管理员暂未设置好学期</font>";
        }
    }
    /// <summary>
    /// 获取当前是几年级
    /// </summary>
    /// <param name="NowTerm">目前设置的学期是哪一年的</param>
    /// <param name="YeIn">入学年份</param>
    /// <param name="onetwo">目前是第一学期[false]还是第二学期[true] </param>
    /// <param name="isgrade">学段1 小学 2初中 3 高中</param>
    /// <returns></returns>
    protected string GetHowGrade(int NowTerm, int YeIn, bool onetwo, int isgrade)
    {
        int isclass, ot;
        if (!onetwo)
        {
            ot = 1;
        }
        else
        {
            ot = 0;
        }
        isclass = NowTerm - YeIn + ot;
        if (isclass <= 0)
        {
            return "<font color=red>还没开学</font>";
        }
        else if (isclass > 6 && isgrade == 1)
        {

            return "<font color=red>已经毕业</font>";
        }
        else if (isclass > 3 && (isgrade == 2 || isgrade == 3))
        {

            return "<font color=red>已经毕业</font>";
        }
        else
        {
            return GetTypeAge(isgrade.ToString()) + this.Temp(isclass) + "年级";
        }
    }
    /// <summary>
    /// 获取年级名称
    /// </summary>
    /// <param name="str">年级数字</param>
    /// <returns></returns>
    protected string GetTypeAge(string str)
    {
        if (str == "1")
        {
            return "小学";
        }
        else if (str == "2")
        {
            return "初中";
        }
        else
        {
            return "高中";

        }
    }
    /// <summary>
    /// 分页控件页索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadAskByCID();
    }
    /// <summary>
    /// 截取标题
    /// </summary>
    /// <param name="title"></param>
    /// <returns></returns>
    protected object ConvertTitle(object title)
    {
        object obj = "";
        try
        {
            if (title.ToString().Length > 25)
                obj = title.ToString().Substring(0, 22) + "...";
            else
                obj = title;
        }
        catch { }
        return obj;
    }
    /// <summary>
    /// 获取学科名称
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetSujectName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Subject().GetModel(Convert.ToInt32(sid)).Name;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
    /// <summary>
    /// 获取学生姓名
    /// </summary>
    /// <param name="sid"></param>
    /// <returns></returns>
    protected object GetStudentName(object sid)
    {
        object obj = "";
        try
        {
            if (sid.ToString() == "0")
            {
                obj = "未知";
            }
            else
            {
                obj = new WinStar.BLL.Student().GetModel(Convert.ToInt32(sid)).TrueName;
            }
        }
        catch { obj = "未知"; }
        return obj;
    }
}