﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_CommentAdd : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.Model.GroupComment model = new WinStar.Model.GroupComment();
                model.Content = this.txtCommentContent.Text.Trim();
                model.CreateTime = DateTime.Now;
                model.GroupId = Convert.ToInt32(Request.QueryString["id"]);

                WinStar.BLL.GroupComment bll = new WinStar.BLL.GroupComment();
                int effectCount = bll.Add(model);
                if (effectCount > 0)
                {
                    Common.alert("添加成功！","CommentList.aspx?id="+Request.QueryString["id"]);
                }
                else
                {
                    Common.alert("添加失败，请重试");
                }
            }
            catch { Common.alert("添加失败，请重试"); }
        }
    }
}