﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Teacher_CommentEdit : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]) && !string.IsNullOrEmpty(Request.QueryString["gid"]))
            {
                int id = 0;
                int gid = 0;
                try
                {
                    id = Convert.ToInt32(Request.QueryString["id"]);
                    gid = Convert.ToInt32(Request.QueryString["gid"]);
                }
                catch { Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1); }

                if (id == 0 || gid == 0)
                {
                    Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
                }
                else
                {
                    this.LoadGroupInfo(gid);
                    this.LoadCommentInfo(id);
                }
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    /// <summary>
    /// 加载评语信息
    /// </summary>
    /// <param name="id">评语id</param>
    private void LoadCommentInfo(int id)
    {
        try
        {
            WinStar.Model.GroupComment model = new WinStar.BLL.GroupComment().GetModel(id);
            this.txtCommentContent.Text = model.Content;
        }
        catch { }
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id">小组id</param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 提交按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            try
            {
                WinStar.BLL.GroupComment bll = new WinStar.BLL.GroupComment();
                WinStar.Model.GroupComment model = new WinStar.BLL.GroupComment().GetModel(Convert.ToInt32(Request.QueryString["id"]));
                model.Content = this.txtCommentContent.Text.Trim();

                bll.Update(model);

                Common.alert("修改成功！","CommentList.aspx?id="+Request.QueryString["gid"]);
            }
            catch { Common.alert("修改失败，请重试"); }
        }
    }
}