﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class Teacher_CommentList : TeacherPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(Request.QueryString["id"]))
            {
                if (!string.IsNullOrEmpty(Request.QueryString["cid"])) //请求的是删除操作
                {
                    int nid = Convert.ToInt32(Request.QueryString["cid"]);
                    bool isSuccess = this.DeleteCommentById(nid);
                    if (!isSuccess)
                    {
                        Common.alert("删除失败，请重试！");
                    }
                }

                int gid = Convert.ToInt32(Request.QueryString["id"]);

                this.LoadGroupInfo(gid);

                this.LoadCommentList();
            }
            else
            {
                Common.alert("抱歉，您访问的地址不存在！", "Default.aspx", 1);
            }
        }
    }
    private bool DeleteCommentById(int id)
    {
        bool result = false;
        try
        {
            new WinStar.BLL.GroupComment().Delete(id);

            result = true;
        }
        catch { }
        return result;
    }
    /// <summary>
    /// 加载小组信息
    /// </summary>
    /// <param name="id"></param>
    protected void LoadGroupInfo(int id)
    {
        try
        {
            WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(id);
            this.ltGroupInfo.Text = "<a href=\"GroupIndex.aspx?id=" + id + "\">" + model.Name + " 小组首页</a>";
        }
        catch { }
    }
    /// <summary>
    /// 加载小组评语评论者名称
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    protected string LoadCommentUserName(object id)
    {
        string userName = "指导老师";
        try
        {
            int groupId = Convert.ToInt32(id);
            WinStar.Model.Group gmodel = new WinStar.BLL.Group().GetModel(groupId);
            WinStar.Model.Teacher model = new WinStar.BLL.Teacher().GetModel(Convert.ToInt32(gmodel.TeacherId));
            userName += model.TrueName;
        }
        catch { }
        return userName;
    }
    /// <summary>
    /// 加载小组评语
    /// </summary>
    protected void LoadCommentList()
    {
        try
        {
            WinStar.BLL.GroupComment bll = new WinStar.BLL.GroupComment();

            PagedDataSource pds = new PagedDataSource();

            string sqlWhere = string.Format(" GroupId={0} order by CreateTime Desc", Convert.ToInt32(Request.QueryString["id"]));
            DataTable dt = bll.GetList(sqlWhere).Tables[0];

            pds.DataSource = dt.DefaultView;

            this.AspNetPager1.RecordCount = pds.Count;
            pds.AllowPaging = true;
            pds.CurrentPageIndex = this.AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = this.AspNetPager1.PageSize;

            this.rptCommentList.DataSource = pds;
            this.rptCommentList.DataBind();
        }
        catch { }
    }
    /// <summary>
    /// 写评语按钮单击事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        int gid = Convert.ToInt32(Request.QueryString["id"]);
        WinStar.Model.Group model = new WinStar.BLL.Group().GetModel(gid);
        if (model.TeacherId == Convert.ToInt32(Session["TeacherId"]))
        {
            Response.Redirect("CommentAdd.aspx?id=" + Request.QueryString["id"]);
        }
        else
        {
            Common.alert("抱歉，您不是该小组的指导老师，不能为该小组写评语！");
        }
    }
    /// <summary>
    /// 分页控件也索引更改事件
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void AspNetPager1_PageChanged(object sender, EventArgs e)
    {
        this.LoadCommentList();
    }
}